package com.upyuns.platform.rs.website.controller.web;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.biz.GainDataBiz;
import com.upyuns.platform.rs.website.biz.GaindataLogBiz;
import com.upyuns.platform.rs.website.entity.DataTempcache;
import com.upyuns.platform.rs.website.entity.GainData;
import com.upyuns.platform.rs.website.entity.GaindataLog;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping("gaindataLog/web")
public class GaindataLogController extends BaseController<GaindataLogBiz,GaindataLog> {

    @Autowired
    GainDataBiz gainDataBiz;

    //1001--录入；2211--生产线镶嵌；2212--生产线温度反演；2213--生产线植被覆盖度；2214--生产线植被识别；2215--生产线水体识别；2216--生产线风险等级；2217--生产线病虫害监测
//    static Map<String, String>
//
//    static {
//
//    }

    @RequestMapping(value = "/app/unauth/baseAdd",method = RequestMethod.POST)
    @ResponseBody
    public ObjectRestResponse<GaindataLog> appunauthBaseAdd(@RequestBody GaindataLog entity){
//        if(GaindataLog.TYPE_1001.equals())
        String content = "{}";
//                "进行了一次{}操作";
        if(null != entity.getGainId()) {
            GainData gainData = gainDataBiz.selectById(entity.getGainId());
            if(null != gainData) {
                if(GaindataLog.TYPE_2211.equals(entity.getType())) {
                    entity.setContent(StrUtil.format(content, "生产线镶嵌"));
                } else if(GaindataLog.TYPE_2212.equals(entity.getType())) {
                    entity.setContent(StrUtil.format(content, "生产线温度反演"));
                } else if(GaindataLog.TYPE_2213.equals(entity.getType())) {
                    entity.setContent(StrUtil.format(content, "生产线植被覆盖度计算"));
                } else if(GaindataLog.TYPE_2214.equals(entity.getType())) {
                    entity.setContent(StrUtil.format(content, "生产线植被识别"));
                } else if(GaindataLog.TYPE_2215.equals(entity.getType())) {
                    entity.setContent(StrUtil.format(content, "生产线水体识别"));
                } else if(GaindataLog.TYPE_2216.equals(entity.getType())) {
                    entity.setContent(StrUtil.format(content, "生产线风险等级分析"));
                } else if(GaindataLog.TYPE_2217.equals(entity.getType())) {
                    entity.setContent(StrUtil.format(content, "生产线病虫害监测"));
                } else if(GaindataLog.TYPE_2221.equals(entity.getType())) {
                    entity.setContent(StrUtil.format(content, "生产线切片"));
                } else if(GaindataLog.TYPE_2311.equals(entity.getType())) {
                    entity.setContent(StrUtil.format(content, "AI系统船舶识别"));
                }
                baseBiz.insertSelective(entity);
                return ObjectRestResponse.succ();
            }
        }
        return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "参数错误");
    }


    @ApiOperation("查询分页-ObjectRestResponse")
    @RequestMapping(value = "/app/unauth/logicPages",method = RequestMethod.GET)
    @IgnoreUserToken
    @ResponseBody
    public ObjectRestResponse<PageDataVO<DataTempcache>> unauthBaseLogicPages(@RequestParam Map<String, Object> params){
        //查询列表数据
        Query query = new Query(params);
        return ObjectRestResponse.succ(baseBiz.selectByQueryLogicPage(query));
    }
}