package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.admin.constant.AdminCommonConstant;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ImageimgMenuBiz;
import com.upyuns.platform.rs.website.entity.DataMenu;
import com.upyuns.platform.rs.website.entity.ImageimgMenu;
import com.upyuns.platform.rs.website.vo.ImageimgMenuTree;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@RestController
@RequestMapping("/imageimgMenu")
public class AdminImageimgMenuController extends BaseController<ImageimgMenuBiz,ImageimgMenu> {

    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse<List<ImageimgMenuTree>> getTree(String title) {
        Example example = new Example(DataMenu.class);
        if (StringUtils.isNotBlank(title)) {
            example.createCriteria().andLike("title", "%" + title + "%");
        }
        return ObjectRestResponse.succ(baseBiz.getImageimgMenuTree(baseBiz.selectByExample(example), AdminCommonConstant.ROOT));
    }
}