package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Data;

/**
 * 服务能力
 * @TableName service_capability
 */
@Table(name="service_capability")
@Data
public class ServiceCapability implements Serializable {
    /**
     *
     */
    @Id
    private Integer id;

    /**
     * 计算能力(单位：GHz)
     */
    @Column(name = "computing_power")
    private BigDecimal computingPower;

    /**
     * 数据总量(单位：TB)
     */
    @Column(name = "data_volume")
    private BigDecimal dataVolume;

    /**
     * 数据集(单位：个)
     */
    @Column(name = "data_set")
    private Integer dataSet;

    /**
     * 在库数据量(单位：TB)
     */
    @Column(name = "Library_data")
    private BigDecimal libraryData;

    /**
     * 存储能力(单位：TB)
     */
    @Column(name = "storage_capacity")
    private BigDecimal storageCapacity;

    /**
     * 数据(单位：条)
     */
    @Column(name = "data_count")
    private Integer dataCount;

    /**
     * 状态：1.上架 2.下架
     */
    private Byte status;

    /**
     * 是否删除：0、否， 1、是
     */
    @Column(name = "is_del")
    private Byte isDel;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @Column(name = "create_user")
    private Long createUser;

    /**
     * 更新时间
     */
    @Column(name = "last_update_time")
    private Date lastUpdateTime;

    /**
     * 更新人
     */
    @Column(name = "last_update_user")
    private Long lastUpdateUser;

    private static final long serialVersionUID = 1L;
}
