package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 通知信息
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2020-12-28 14:12:25
 */
@Data
@Table(name = "notice_info")
public class NoticeInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  消息
     */
    @Column(name = "message")
	@ApiModelProperty(value = "消息")
    private String message;
	
	    /**
     *  类型
     */
    @Column(name = "type")
	@ApiModelProperty(value = "类型")
    private Integer type;
	
	    /**
     *  是否已读：1、未读，2、已读
     */
    @Column(name = "is_read")
	@ApiModelProperty(value = "是否已读：1、未读，2、已读")
    private Integer isRead;
	
	    /**
     *  是否删除：0、否，1、是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0、否，1、是")
    private Integer isDel;
	
	    /**
     *  用户ID
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户ID")
    private Integer userId;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;

	/**
	 * 关联ID
	 */
	private String relationId;
}
