package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 绿美阳西信息产品服务
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2024-10-18 15:07:02
 */
@Data
@Table(name = "lmyxmonitorimage")
public class Lmyxmonitorimage implements Serializable {
	private static final long serialVersionUID = 1L;

	public static final int STATE_UP = 1;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  标题名称
     */
    @Column(name = "title")
	@ApiModelProperty(value = "标题名称")
    private String title;
	
	    /**
     *  资源唯一的标识名字图层名
     */
    @Column(name = "resourcename")
	@ApiModelProperty(value = "资源唯一的标识名字图层名")
    private String resourcename;
	
	    /**
     *  坐标系
     */
    @Column(name = "extent_srs")
	@ApiModelProperty(value = "坐标系")
    private String extentSrs;
	
	    /**
     *  数据有效四至地理范围
     */
    @Column(name = "extent")
	@ApiModelProperty(value = "数据有效四至地理范围")
    private String extent;
	
	    /**
     *  层级范围
     */
    @Column(name = "level")
	@ApiModelProperty(value = "层级范围")
    private String level;
	
	    /**
     *  服务地址
     */
    @Column(name = "url")
	@ApiModelProperty(value = "服务地址")
    private String url;
	
	    /**
     *  图例地址
     */
    @Column(name = "legend_url")
	@ApiModelProperty(value = "图例地址")
    private String legendUrl;
	
	    /**
     *  状态 1--上架；2--下架
     */
    @Column(name = "state")
	@ApiModelProperty(value = "状态 1--上架；2--下架")
    private Integer state;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "crt_user")
	@ApiModelProperty(value = "")
    private String crtUser;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;
	
	    /**
     *  
     */
    @Column(name = "upd_user")
	@ApiModelProperty(value = "")
    private String updUser;
	
	    /**
     *  是否删除 1--已删除；0--未删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除 1--已删除；0--未删除")
    private Integer isDel;

	/**
	 *  类型：2212--温度反演；2213--植被覆盖度；2214--植被识别；2215--水体识别；2216--风险等级；2217--病虫害监测
	 */
	@Column(name = "type")
	@ApiModelProperty(value = "类型：2212--温度反演；2213--植被覆盖度；2214--植被识别；2215--水体识别；2216--风险等级；2217--病虫害监测")
	private Integer type;

}
