package com.upyuns.platform.rs.datacenter.rest.backstage;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpMosaicimageBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpMosaicimage;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.RscpMosaicimageDTO;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;


@RestController
@RequestMapping("/bg/rscpmosaicimage")
public class BgRscpmosaicimageController extends BaseController<RscpMosaicimageBiz, RscpMosaicimage> {


    @ApiOperation("遥感影像管理")
    @RequestMapping(value = "/mapAll",method = RequestMethod.GET)
    public ObjectRestResponse<PageDataVO<RscpMosaicimage>> getPageList(RscpMosaicimageDTO dto) throws Exception {
        Example example = new Example(RscpMosaicimage.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel",0);
        if (StringUtils.isNotBlank(dto.getName())){
          criteria.andLike("title", "%" + dto.getName() + "%");
        }
        example.setOrderByClause("id desc");
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
       return ObjectRestResponse.succ(pageDataVO);
        }

    @RequestMapping(value = "/addRscpMosaicimage",method = RequestMethod.POST)
    public ObjectRestResponse <RscpMosaicimage> addMosaicimage(@RequestBody RscpMosaicimage rscpMosaicimage ) {
        if (rscpMosaicimage.getId()==null){
            rscpMosaicimage.setIsDel(0);
            if(rscpMosaicimage.getStatus() == null) {
                rscpMosaicimage.setStatus(2);
            }
            if(StrUtil.isBlank(rscpMosaicimage.getSrs())) {
                rscpMosaicimage.setSrs("EPSG:4326");
            }
            if(StrUtil.isBlank(rscpMosaicimage.getExtentSrs())) {
                rscpMosaicimage.setExtentSrs("EPSG:4326");
            }
            baseBiz.insertSelective(rscpMosaicimage);
        }else {
            rscpMosaicimage.setIsDel(0);
            baseBiz.updateSelectiveById(rscpMosaicimage);
        }
        return ObjectRestResponse.succ();
    }



    @DeleteMapping("/deleteById")
    public ObjectRestResponse deleteInoPortAnalyse(Integer id) {
        RscpMosaicimage monitorimage = new RscpMosaicimage();
        monitorimage.setId(id);
        monitorimage.setIsDel(1);
        baseBiz.updateSelectiveById(monitorimage);
        return ObjectRestResponse.succ();
    }












}
