package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.AssertUtils;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.upyuns.platform.rs.datacenter.biz.*;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImageInputLog;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import com.upyuns.platform.rs.datacenter.entity.RscpStorageJson;
import com.upyuns.platform.rs.datacenter.fegin.RscloudboxClientRest;
import com.upyuns.platform.rs.datacenter.pojo.ImageDataVO;
import com.upyuns.platform.rs.datacenter.pojo.ImagePageFeginDTO;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.QueryDTO;
import com.upyuns.platform.rs.datacenter.vo.ImageInputVO;
import com.upyuns.platform.rs.gtdata.GtDataRestClient;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("/web/rscpStorageJson")
public class RscpStorageJsonController extends BaseController<RscpStorageJsonBiz, RscpStorageJson> {

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public ObjectRestResponse save(@RequestBody RscpStorageJson rscpStorageJson) {

        AssertUtils.isBlank(rscpStorageJson);
        AssertUtils.isBlank(rscpStorageJson.getContextJson());

        rscpStorageJson.setUserId(getCurrentUserIdInt());
        //判断会否存在
        List<RscpStorageJson> dbList = baseBiz.selectList(new RscpStorageJson(){{
            setUserId(getCurrentUserIdInt());
            setIsDel(SYS_FALSE);
        }});

        if(CollUtil.isNotEmpty(dbList)) {
            rscpStorageJson.setId(dbList.get(0).getId());
            baseBiz.updateSelectiveById(rscpStorageJson);
        }else {
            baseBiz.insertSelective(rscpStorageJson);
        }
        return ObjectRestResponse.succ();
    }

    @RequestMapping(value = "/detail", method = RequestMethod.GET)
    public ObjectRestResponse detail(RscpStorageJson rscpStorageJson) {

//        AssertUtils.isBlank(rscpStorageJson);
//        AssertUtils.isBlank(rscpStorageJson.getId());

        //判断会否存在
        List<RscpStorageJson> dbList = baseBiz.selectList(new RscpStorageJson(){{
            setUserId(getCurrentUserIdInt());
//            setId(rscpStorageJson.getId());
            setIsDel(SYS_FALSE);
        }});

        if(CollUtil.isNotEmpty(dbList)) {
            return ObjectRestResponse.succ(dbList.get(0));
        }else {
            return ObjectRestResponse.succ();
        }
    }

}