/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.protocol;

import java.io.IOException;
import ytx.org.apache.http.HttpEntity;
import ytx.org.apache.http.HttpEntityEnclosingRequest;
import ytx.org.apache.http.HttpException;
import ytx.org.apache.http.HttpRequest;
import ytx.org.apache.http.HttpRequestInterceptor;
import ytx.org.apache.http.HttpVersion;
import ytx.org.apache.http.ProtocolVersion;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.params.HttpProtocolParams;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntity entity;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null && entity.getContentLength() != 0L) {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (HttpProtocolParams.useExpectContinue(request.getParams()) && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

