package com.upyuns.platform.rs.universal.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 订单支付
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-28 16:17:42
 */
@Data
@Table(name = "order_pay")
public class OrderPay implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    //支付订单号
    @Column(name = "trade_no")
	@ApiModelProperty(value = "支付订单号")
    private String tradeNo;
	
	    //订单号
    @Column(name = "order_no")
	@ApiModelProperty(value = "订单号")
    private String orderNo;
	
	    //用户id
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    //1:微信公众号支付 2.支付宝即时到账,3,银联
    @Column(name = "pay_way")
	@ApiModelProperty(value = "1:微信公众号支付 2.支付宝即时到账,3,银联")
    private Integer payWay;

	@Column(name = "pay_type")
    @ApiModelProperty(value = "1：支付宝APP支付，2：支付宝预授权支付")
    private Integer payType;

	    //渠道：1-租车;2-旅游
    @Column(name = "channel")
	@ApiModelProperty(value = "渠道：1-租车;2-旅游")
    private Integer channel;
	
	    //来源:1-app;2-小程序
    @Column(name = "type")
	@ApiModelProperty(value = "来源:1-app;2-小程序")
    private Integer type;
	
	    //买家IP地址
    @Column(name = "buyer_ip")
	@ApiModelProperty(value = "买家IP地址")
    private String buyerIp;
	
	    //商品标题
    @Column(name = "subject")
	@ApiModelProperty(value = "商品标题")
    private String subject;
	
	    //商品描述信息
    @Column(name = "body")
	@ApiModelProperty(value = "商品描述信息")
    private String body;
	
	    //回调地址
    @Column(name = "notify_url")
	@ApiModelProperty(value = "回调地址")
    private String notifyUrl;
	
	    //支付状态0：未支付 1：已支付
    @Column(name = "status")
	@ApiModelProperty(value = "支付状态0：未支付 1：已支付")
    private Integer status;
	
	    //支付金额
    @Column(name = "amount")
	@ApiModelProperty(value = "支付金额")
    private Integer amount;
	
	    //是否删除
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除")
    private Integer isDel;
	
	    //支付接口返回的流水号
    @Column(name = "serial_number")
	@ApiModelProperty(value = "支付接口返回的流水号")
    private String serialNumber;
	
	    //买家第三方付款账号
    @Column(name = "buyer_account")
	@ApiModelProperty(value = "买家第三方付款账号")
    private String buyerAccount;
	
	    //卖家第三方收款账号
    @Column(name = "seller_account")
	@ApiModelProperty(value = "卖家第三方收款账号")
    private String sellerAccount;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    //支付完成时间
    @Column(name = "finish_time")
	@ApiModelProperty(value = "支付完成时间")
    private Long finishTime;
	

}
