package com.upyuns.platform.rs.universal.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 消息推送表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-28 16:17:42
 */
@Data
@Table(name = "message_push")
public class MessagePush implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	

	@ApiModelProperty(value = "1-手动推送；2-系统自动推送")
    private Integer type;

	@Column(name = "send_type")
	@ApiModelProperty(value = "系统发送类型：1-支付完成")
	private Integer sendType;

	@ApiModelProperty(value = "通知标题")
    private String title;
	

	@ApiModelProperty(value = "通知内容")
    private String alert;


	@ApiModelProperty(value = "通知栏样式类型:1-大文本；2-文本条目；3-大图片")
    private Integer style;
	

    @Column(name = "big_text")
	@ApiModelProperty(value = "大文本通知栏样式")
    private String bigText;
	

	@ApiModelProperty(value = "文本条目通知栏样式")
    private String inbox;
	

    @Column(name = "big_pic_path")
	@ApiModelProperty(value = "大图片通知栏样式")
    private String bigPicPath;
	

	@ApiModelProperty(value = "指定跳转页面")
    private String intent;


	@Column(name = "jump_type")
	@ApiModelProperty(value = "跳转页面类型：0-进入app；其他见枚举")
	private Integer jumpType;

	@Column(name = "url_json")
	@ApiModelProperty(value = "指定跳转地址")
	private String urlJson;


	@Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
	private Long crtTime;


	@Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
	private Long updTime;
	

    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除")
    private Integer isDel;


	

}
