package com.upyuns.platform.rs.universal.entity;

import javax.persistence.*;
import java.util.Date;

@Table(name = "member_info")
public class MemberInfo {

    public static final Boolean SEX_MAN = false;
    public static final Boolean SEX_WOMAN = true;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "JDBC")
    private Integer id;

    /**
     * 姓名
     */
    private String name;

    /**
     * 性别(0:男,1:女)
     */
    private Boolean sex;

    /**
     * 卡号
     */
    @Column(name = "card_number")
    private String cardNumber;

    /**
     * 生日
     */
    private Date birthday;

    /**
     * 身份证号
     */
    @Column(name = "id_number")
    private String idNumber;

    /**
     * 证件地址
     */
    @Column(name = "certificate_address")
    private String certificateAddress;

    /**
     * 电子邮件
     */
    private String email;

    /**
     * 微信
     */
    private String wx;

    /**
     * 会员类型(0:会员,1:VIP会员,2:砖石会员)
     */
    @Column(name = "member_type")
    private Byte memberType;

    /**
     * 联系电话
     */
    private String telephone;

    /**
     * 手机
     */
    @Column(name = "mobile_phone")
    private String mobilePhone;

    /**
     * 常住地址
     */
    private String address;

    /**
     * 工作单位
     */
    private String workplace;

    /**
     * 职务
     */
    private String job;

    /**
     * 邀约人
     */
    private String inviter;

    /**
     * 职业
     */
    private String profession;

    /**
     * 支付方式(0:现金,1:刷卡,2:微信支付,3:支付宝支付,4:银行转账)
     */
    @Column(name = "pay_type")
    private Byte payType;

    /**
     * 会员签名日期
     */
    @Column(name = "member_signature_date")
    private Date memberSignatureDate;

    /**
     * 经理
     */
    private String manager;

    /**
     * 经理签名日期
     */
    @Column(name = "manager_signature_date")
    private Date managerSignatureDate;

    /**
     * 创建日期
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人用户id
     */
    @Column(name = "create_user_id")
    private Integer createUserId;

    /**
     * 创建人姓名
     */
    @Column(name = "create_user_name")
    private String createUserName;

    /**
     * 会员状态(-1:停用,0:未审核,1:正常)
     */
    private Byte state;

    /**
     * @return id
     */
    public Integer getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取姓名
     *
     * @return name - 姓名
     */
    public String getName() {
        return name;
    }

    /**
     * 设置姓名
     *
     * @param name 姓名
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取性别(0:男,1:女)
     *
     * @return sex - 性别(0:男,1:女)
     */
    public Boolean getSex() {
        return sex;
    }

    /**
     * 设置性别(0:男,1:女)
     *
     * @param sex 性别(0:男,1:女)
     */
    public void setSex(Boolean sex) {
        this.sex = sex;
    }

    /**
     * 获取卡号
     *
     * @return card_number - 卡号
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /**
     * 设置卡号
     *
     * @param cardNumber 卡号
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber == null ? null : cardNumber.trim();
    }

    /**
     * 获取生日
     *
     * @return birthday - 生日
     */
    public Date getBirthday() {
        return birthday;
    }

    /**
     * 设置生日
     *
     * @param birthday 生日
     */
    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    /**
     * 获取身份证号
     *
     * @return id_number - 身份证号
     */
    public String getIdNumber() {
        return idNumber;
    }

    /**
     * 设置身份证号
     *
     * @param idNumber 身份证号
     */
    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber == null ? null : idNumber.trim();
    }

    /**
     * 获取证件地址
     *
     * @return certificate_address - 证件地址
     */
    public String getCertificateAddress() {
        return certificateAddress;
    }

    /**
     * 设置证件地址
     *
     * @param certificateAddress 证件地址
     */
    public void setCertificateAddress(String certificateAddress) {
        this.certificateAddress = certificateAddress == null ? null : certificateAddress.trim();
    }

    /**
     * 获取电子邮件
     *
     * @return email - 电子邮件
     */
    public String getEmail() {
        return email;
    }

    /**
     * 设置电子邮件
     *
     * @param email 电子邮件
     */
    public void setEmail(String email) {
        this.email = email == null ? null : email.trim();
    }

    /**
     * 获取微信
     *
     * @return wx - 微信
     */
    public String getWx() {
        return wx;
    }

    /**
     * 设置微信
     *
     * @param wx 微信
     */
    public void setWx(String wx) {
        this.wx = wx == null ? null : wx.trim();
    }

    /**
     * 获取会员类型(0:会员,1:VIP会员,2:砖石会员)
     *
     * @return member_type - 会员类型(0:会员,1:VIP会员,2:砖石会员)
     */
    public Byte getMemberType() {
        return memberType;
    }

    /**
     * 设置会员类型(0:会员,1:VIP会员,2:砖石会员)
     *
     * @param memberType 会员类型(0:会员,1:VIP会员,2:砖石会员)
     */
    public void setMemberType(Byte memberType) {
        this.memberType = memberType;
    }

    /**
     * 获取联系电话
     *
     * @return telephone - 联系电话
     */
    public String getTelephone() {
        return telephone;
    }

    /**
     * 设置联系电话
     *
     * @param telephone 联系电话
     */
    public void setTelephone(String telephone) {
        this.telephone = telephone == null ? null : telephone.trim();
    }

    /**
     * 获取手机
     *
     * @return mobile_phone - 手机
     */
    public String getMobilePhone() {
        return mobilePhone;
    }

    /**
     * 设置手机
     *
     * @param mobilePhone 手机
     */
    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone == null ? null : mobilePhone.trim();
    }

    /**
     * 获取常住地址
     *
     * @return address - 常住地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 设置常住地址
     *
     * @param address 常住地址
     */
    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    /**
     * 获取工作单位
     *
     * @return workplace - 工作单位
     */
    public String getWorkplace() {
        return workplace;
    }

    /**
     * 设置工作单位
     *
     * @param workplace 工作单位
     */
    public void setWorkplace(String workplace) {
        this.workplace = workplace == null ? null : workplace.trim();
    }

    /**
     * 获取职务
     *
     * @return job - 职务
     */
    public String getJob() {
        return job;
    }

    /**
     * 设置职务
     *
     * @param job 职务
     */
    public void setJob(String job) {
        this.job = job == null ? null : job.trim();
    }

    /**
     * 获取邀约人
     *
     * @return inviter - 邀约人
     */
    public String getInviter() {
        return inviter;
    }

    /**
     * 设置邀约人
     *
     * @param inviter 邀约人
     */
    public void setInviter(String inviter) {
        this.inviter = inviter == null ? null : inviter.trim();
    }

    /**
     * 获取职业
     *
     * @return profession - 职业
     */
    public String getProfession() {
        return profession;
    }

    /**
     * 设置职业
     *
     * @param profession 职业
     */
    public void setProfession(String profession) {
        this.profession = profession == null ? null : profession.trim();
    }

    /**
     * 获取支付方式(0:现金,1:刷卡,2:微信支付,3:支付宝支付,4:银行转账)
     *
     * @return pay_type - 支付方式(0:现金,1:刷卡,2:微信支付,3:支付宝支付,4:银行转账)
     */
    public Byte getPayType() {
        return payType;
    }

    /**
     * 设置支付方式(0:现金,1:刷卡,2:微信支付,3:支付宝支付,4:银行转账)
     *
     * @param payType 支付方式(0:现金,1:刷卡,2:微信支付,3:支付宝支付,4:银行转账)
     */
    public void setPayType(Byte payType) {
        this.payType = payType;
    }

    /**
     * 获取会员签名日期
     *
     * @return member_signature_date - 会员签名日期
     */
    public Date getMemberSignatureDate() {
        return memberSignatureDate;
    }

    /**
     * 设置会员签名日期
     *
     * @param memberSignatureDate 会员签名日期
     */
    public void setMemberSignatureDate(Date memberSignatureDate) {
        this.memberSignatureDate = memberSignatureDate;
    }

    /**
     * 获取经理
     *
     * @return manager - 经理
     */
    public String getManager() {
        return manager;
    }

    /**
     * 设置经理
     *
     * @param manager 经理
     */
    public void setManager(String manager) {
        this.manager = manager == null ? null : manager.trim();
    }

    /**
     * 获取经理签名日期
     *
     * @return manager_signature_date - 经理签名日期
     */
    public Date getManagerSignatureDate() {
        return managerSignatureDate;
    }

    /**
     * 设置经理签名日期
     *
     * @param managerSignatureDate 经理签名日期
     */
    public void setManagerSignatureDate(Date managerSignatureDate) {
        this.managerSignatureDate = managerSignatureDate;
    }

    /**
     * 获取创建日期
     *
     * @return create_date - 创建日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建日期
     *
     * @param createDate 创建日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人用户id
     *
     * @return create_user_id - 创建人用户id
     */
    public Integer getCreateUserId() {
        return createUserId;
    }

    /**
     * 设置创建人用户id
     *
     * @param createUserId 创建人用户id
     */
    public void setCreateUserId(Integer createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * 获取创建人姓名
     *
     * @return create_user_name - 创建人姓名
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 设置创建人姓名
     *
     * @param createUserName 创建人姓名
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    /**
     * 获取会员状态(-1:停用,0:未审核,1:正常)
     *
     * @return state - 会员状态(-1:停用,0:未审核,1:正常)
     */
    public Byte getState() {
        return state;
    }

    /**
     * 设置会员状态(-1:停用,0:未审核,1:正常)
     *
     * @param state 会员状态(-1:停用,0:未审核,1:正常)
     */
    public void setState(Byte state) {
        this.state = state;
    }
}