package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ShoppingCartInfoBiz;
import com.upyuns.platform.rs.website.dto.CartOrderDto;
import com.upyuns.platform.rs.website.dto.OrderInfoDto;
import com.upyuns.platform.rs.website.entity.ShoppingCartInfo;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("shoppingCartInfo/web")
public class ShoppingCartInfoWebController extends BaseController<ShoppingCartInfoBiz,ShoppingCartInfo> {

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody OrderInfoDto orderInfoDto) {
		return baseBiz.addShoppingCart(orderInfoDto);
	}

	@GetMapping(value = "getUserShoppingCart")
	public ObjectRestResponse getUserShoppingCart(OrderInfoDto orderInfoDto) {
		return baseBiz.getUserAllCart(orderInfoDto);
	}

	@PostMapping(value = "convertToOrderInfo")
	public ObjectRestResponse convertToOrderInfo(CartOrderDto cartOrderDto) {
		return baseBiz.convertShopCartToOrderInfo(cartOrderDto);
	}

	@DeleteMapping(value = "deleteOne")
	public ObjectRestResponse deleteOne(Integer id) {
		return baseBiz.deleteOne(id);
	}

	@DeleteMapping(value = "deleteBatch")
	public ObjectRestResponse deleteBatch(String ids) {
		return baseBiz.deleteBatch(ids);
	}

}