package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.IndustryApplicationInfoBiz;
import com.upyuns.platform.rs.website.dto.IndustryApplicationInfoDto;
import com.upyuns.platform.rs.website.entity.IndustryApplicationInfo;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("industryApplicationInfo/web")
public class IndustryApplicationWebInfoController extends BaseController<IndustryApplicationInfoBiz, IndustryApplicationInfo> {

	@GetMapping(value = "/app/unauth/getList")
	@IgnoreUserToken
	public ObjectRestResponse getList(IndustryApplicationInfoDto industryApplicationInfoDto) {
		industryApplicationInfoDto.setSortType(1);
		industryApplicationInfoDto.setStatus(1);
		return baseBiz.selectList(industryApplicationInfoDto);
	}

	@GetMapping(value = "/app/unauth/getAll")
	@IgnoreUserToken
	public ObjectRestResponse getAll() {
		return baseBiz.getAllIndexShow();
	}

	@GetMapping(value = "/app/unauth/detail")
	@IgnoreUserToken
	public ObjectRestResponse detail(Integer id) {
		return ObjectRestResponse.succ(baseBiz.selectById(id));
	}

}