package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.upyuns.platform.rs.website.biz.CustomFormBiz;
import com.upyuns.platform.rs.website.dto.custom.CustomQueryDTO;
import com.upyuns.platform.rs.website.entity.CustomForm;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;

@RestController
@RequestMapping("customForm")
public class CustomFormController extends BaseController<CustomFormBiz,CustomForm> {

    @RequestMapping(value = "pageList",method = RequestMethod.GET)
    public ObjectRestResponse<PageDataVO<CustomForm>> pageList(CustomQueryDTO dto) {
        return ObjectRestResponse.succ(PageDataVO.pageInfo(dto.initQuery(), () -> baseBiz.selectByWeekend(w -> {
            w.andEqualTo(CustomForm::getIsDel, SYS_FALSE);
            if(null != dto.getType()) {
                w.andEqualTo(CustomForm::getType, dto.getType());
            }
            if(null != dto.getStatus()) {
                w.andEqualTo(CustomForm::getStatus, dto.getStatus());
            }
            return w;
        }, " 'status' asc, crt_time desc")));
    }

}