package com.upyuns.platform.rs.website.type;

/**
 * @ClassName : OrderStatusEnum
 * @Description : 订单发货状态
 * @Author : jiaoruizhen
 * 订单发货状态：0待发货，1已发货，2收货，3退货,
 * @Date: 2020-12-12 16:50
 */
public enum OrderShippingStatusEnum {
	ORDER_NO_SEND(0, "待发货"),
	ORDER_SEND(1, "已发货"),
	ORDER_RECEIVED(2, "已收货"),
	ORDER_REFUND(3, "退货");
	private Integer type;
	private String msg;

	OrderShippingStatusEnum(Integer type, String msg) {
		this.type = type;
		this.msg = msg;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}


	public static <T extends OrderShippingStatusEnum> String getType(Integer code, Class<T> t) {
		for (T item : t.getEnumConstants()) {
			if (item.getType().equals(code)) {
				return item.getMsg();
			}
		}
		return "";
	}

	public static OrderShippingStatusEnum getByCode(Integer code) {
		for (OrderShippingStatusEnum v : values()) {
			if (v.getType() == code) {
				return v;
			}
		}
		return null;
	}

	public static String getProductStatusEnum(Integer code) {
		return getType(code, OrderShippingStatusEnum.class);
	}

}
