package com.upyuns.platform.rs.website.type;

/**
 * @ClassName : NoticeTypeEnum
 * @Description : 通知类型
 * @Author : jiaoruizhen
 * @Date: 2020-12-24 14:32
 */
public enum NoticeTypeEnum {

	ORDER_INFO(1, "订单信息"),
	SYSTEM_INFO(2, "系统信息"),
	OTHER_INFO(3, "其他信息");
	private Integer type;
	private String msg;

	NoticeTypeEnum(Integer type, String msg) {
		this.type = type;
		this.msg = msg;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}


	public static <T extends NoticeTypeEnum> String getType(Integer code, Class<T> t) {
		for (T item : t.getEnumConstants()) {
			if (item.getType().equals(code)) {
				return item.getMsg();
			}
		}
		return "";
	}

	public static NoticeTypeEnum getByCode(Integer code) {
		for (NoticeTypeEnum v : values()) {
			if (v.getType() == code) {
				return v;
			}
		}
		return null;
	}

	public static String getProductStatusEnum(Integer code) {
		return getType(code, NoticeTypeEnum.class);
	}

}
