package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 订单商品信息
 * 
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Data
@Table(name = "order_item")
public class OrderItem implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Long itemId;
	
	    /**
     *  订单ID
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "订单ID")
    private Long orderId;
	
	    /**
     *  商品名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "商品名称")
    private String name;
	
	    /**
     *  详情id
     */
    @Column(name = "detail_id")
	@ApiModelProperty(value = "详情id")
    private Long detailId;
	
	    /**
     *  详情json信息
     */
    @Column(name = "detail_json")
	@ApiModelProperty(value = "详情json信息")
    private String detailJson;
	
	    /**
     *  单价
     */
    @Column(name = "price")
	@ApiModelProperty(value = "单价")
    private BigDecimal price;
	
	    /**
     *  数量
     */
    @Column(name = "number")
	@ApiModelProperty(value = "数量")
    private Integer number;
	
	    /**
     *  订单图片
     */
    @Column(name = "item_pic")
	@ApiModelProperty(value = "订单图片")
    private String itemPic;
	
	    /**
     *  下单时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "下单时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;
	
	    /**
     *  1、标准数据，2、影像图库，3、行业应用信息
     */
    @Column(name = "type")
	@ApiModelProperty(value = "1、标准数据，2、影像图库，3、行业应用信息")
    private Integer type;
	
	    /**
     *  文件路径
     */
    @Column(name = "file_path")
	@ApiModelProperty(value = "文件路径")
    private String filePath;
	
	    /**
     *  
     */
    @Column(name = "total_amount")
	@ApiModelProperty(value = "")
    private BigDecimal totalAmount;
	

}
