package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 影像信息介绍信息表
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-11-28 14:15:32
 */
@Data
@Table(name = "image_information")
public class ImageInformation implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 *
	 */
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
	private Integer id;

	/**
	 * 名称
	 */
	@Column(name = "name")
	@ApiModelProperty(value = "名称")
	private String name;

	/**
	 * 分辨率
	 */
	@Column(name = "resolution")
	@ApiModelProperty(value = "分辨率")
	private String resolution;

	/**
	 * 封面图
	 */
	@Column(name = "cover_img")
	@ApiModelProperty(value = "封面图")
	private String coverImg;

	/**
	 * icon图
	 */
	@Column(name = "icon_img")
	@ApiModelProperty(value = "icon图")
	private String iconImg;

	/**
	 * 介绍
	 */
	@Column(name = "intro")
	@ApiModelProperty(value = "介绍")
	private String intro;

	/**
	 * 内容-富文本
	 */
	@Column(name = "content")
	@ApiModelProperty(value = "内容-富文本")
	private String content;

	/**
	 * 是否删除：0、否， 1、是
	 */
	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0、否， 1、是")
	private Integer isDel;

	/**
	 * 排序
	 */
	@Column(name = "rank")
	@ApiModelProperty(value = "排序")
	private Integer rank;

	/**
	 * 是否启用：1、启用，2、禁用
	 */
	@Column(name = "status")
	@ApiModelProperty(value = "是否启用：1、启用，2、禁用")
	private Integer status;

	private Date crtTime;

	private Date updTime;

	private Integer indexShow;

}
