package com.upyuns.platform.rs.universal.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 系统发送类型
 */
public enum PushSendType {
    ALL(0,"全部"),
    VEHICLE_PAY(1,"租车预定成功"),
    TOUR_PAY(2,"旅游预订成功"),
    VEHICLE_CANCEL(3,"租车取消预订"),
    TOUR_CANCEL(4,"旅游取消预订"),
    TAKE_VEHICLE(5,"取车提醒"),
    ALSO_VEHICLE(6,"还车提醒"),
    GET_VEHICLE(7,"上车提醒"),
    VEHICLE_FINISH(8, "租车订单完成"),
    TOUR_FINISH(9, "旅游订单完成"),
    MEMBER_PAY(10, "会员购买成功")
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    private static List<Map<String,Object>> list = new ArrayList<>();

    static{
        for(PushSendType pushSendType : PushSendType.values()){
            codeAndDesc.put(pushSendType.getCode(),pushSendType.getDesc());
            Map<String,Object> map=new HashMap<>();
            map.put("code",pushSendType.getCode());
            map.put("value",pushSendType.getDesc());
            list.add(map);
        }
    }

    PushSendType(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getByCode(Integer code) {
        return codeAndDesc.get(code);
    }
    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

    public static List<Map<String,Object>> getList(){
        return list;
    }

}
