package com.upyuns.platform.rs.datacenter.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaImageTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaInfo;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.mapper.RscpAreaInfoMapper;
import com.upyuns.platform.rs.datacenter.mapper.RscpImageDataTotalMapper;
import com.upyuns.platform.rs.datacenter.pojo.ImageTotalInputDTO;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.BgImageQueryDTO;
import com.upyuns.platform.rs.datacenter.rest.RscpImageDataTotalController;
import com.upyuns.platform.rs.datacenter.vo.ImageInputVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

import static com.github.wxiaoqi.security.common.util.process.ResultCode.PARAM_ILLEGAL_CODE;

@Service
public class RscpImageDataTotalBiz extends BaseBiz<RscpImageDataTotalMapper, RscpImageDataTotal> {


    @Autowired
    RscpAreaInfoMapper rscpAreaInfoMapper;

    public List<RscpImageDataTotal> queryDataList(RscpImageDataTotalController.QueryDTO dto) {
        return mapper.queryDataList(dto);
    }

    public List<RscpImageDataTotal> bgQueryDataList(BgImageQueryDTO dto) {
        return mapper.bgQueryDataList(dto);
    }


    public RscpImageDataTotal queryDataList(String id) {
        List<RscpImageDataTotal> list2 = mapper.queryDataById(id);
        if(list2.size() > 0) {
            RscpImageDataTotal rscpImageDataTotal = list2.get(0);
            return list2.get(0);
        }
        throw new BaseException("数据不存在", PARAM_ILLEGAL_CODE);
    }

    public List<RscpAreaImageTotal> queryDataAreaList(RscpImageDataTotalController.QueryDTO dto) {
        List<RscpImageDataTotal> list = mapper.queryDataList(dto);
        List<RscpAreaImageTotal> list2 = CollUtil.newArrayList();
        if(CollUtil.isNotEmpty(list)) {
            for(RscpImageDataTotal ridt : list) {
                RscpAreaImageTotal rait = BeanUtil.toBean(ridt, RscpAreaImageTotal.class);
                rait.setBeginTime(ridt.getImageTakeTime());
                rait.setImageResolution(rait.getImageResolution().replace("[","{").replace("]", "}"));
                list2.add(rait);
            }
        }
        return list2;
    }

    public String getBinNameByGId(ImageTotalInputDTO dto){
//        String param = StrUtil.format("MULTIPOLYGON((({} {}  ,{} {}  , {} {}  ,#{rightTopLon} #{rightTopLat},   #{leftTopLon} #{leftTopLat})))");
        return mapper.getBinNameByGId(dto.getLeftTopLon(), dto.getLeftTopLat(), dto.getLeftBottomLon(), dto.getLeftBottomLat(), dto.getRightBottomLon(), dto.getRightBottomLat(), dto.getRightTopLon(), dto.getRightTopLat());
    }
    public String geoJsonByRange(String rangeMeta){
        return mapper.geoJsonByRange(rangeMeta);
    }

    public void aaa(ImageInputVO vo) {
        ImageTotalInputDTO dto = BeanUtil.toBean(vo, ImageTotalInputDTO.class);
//        RscpImageDataTotal rscpImageDataTotal = BeanUtil.toBean(vo, RscpImageDataTotal.class);
        dto.setRange(getBinNameByGId(dto));
        List<RscpAreaInfo> imageAreaInfoList = rscpAreaInfoMapper.getIntersectAreaInfo(dto.getRange());
    }
}
