package com.upyuns.platform.rs.gtdata;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpUtils {

	private static JsonMapper jsonMapper = JsonMapper.buildNormalMapper();

	public static Map<String, Object> doGet(String URLString)
			throws IOException {
		CloseableHttpResponse response = null;
		HttpGet httpGet = new HttpGet(URLString);
		Map<String, Object> ret = new HashMap<String, Object>();
		try {
			CloseableHttpClient httpclient = HttpClients.createDefault();
			response = httpclient.execute(httpGet);
			HttpEntity entity = response.getEntity();
			ret.put("HttpStatusCode", response.getStatusLine().getStatusCode());
			if (entity != null) {
				ret.put("response", IOUtils.toString(entity.getContent()));
			}
		} finally {
			IOUtils.closeQuietly((InputStream) response);
			httpGet.abort();
		}
		return ret;
	}

	public static Map<String, Object> doPost(String URLString)
			throws IOException {
		CloseableHttpResponse response = null;
		HttpPost httpPost = new HttpPost(URLString);
		Map<String, Object> ret = new HashMap<String, Object>();
		try {
			CloseableHttpClient httpclient = HttpClients.createDefault();
			response = httpclient.execute(httpPost);
			HttpEntity entity = response.getEntity();
			ret.put("HttpStatusCode", response.getStatusLine().getStatusCode());
			if (entity != null) {
				ret.put("response", IOUtils.toString(entity.getContent()));
			}
		} finally {
			IOUtils.closeQuietly((InputStream) response);
			httpPost.abort();
		}
		return ret;
	}

	/**
	 * Description：HTTP的PUT请求
	 * 
	 * @author WuWenSheng 2016.06.02
	 * @param url
	 * @param params
	 * @return
	 * @throws IOException
	 */
	public static Map<String, Object> doPut(String url,
			List<NameValuePair> params) throws IOException {
		CloseableHttpResponse response = null;
		HttpPut httpPut = new HttpPut(url);
		httpPut.setEntity(new UrlEncodedFormEntity(params));
		Map<String, Object> ret = new HashMap<String, Object>();
		try {
			CloseableHttpClient httpclient = HttpClients.createDefault();
			response = httpclient.execute(httpPut);
			HttpEntity entity = response.getEntity();
			ret.put("HttpStatusCode", response.getStatusLine().getStatusCode());
			if (entity != null) {
				ret.put("response", IOUtils.toString(entity.getContent()));
			}
		} finally {
			IOUtils.closeQuietly((InputStream) response);
			httpPut.abort();
		}
		return ret;
	}

	/**
	 * Description：HTTP的PUT请求（单属性，不传key）
	 * 
	 * @author WuWenSheng 2016.06.02
	 * @param url
	 * @return
	 * @throws IOException
	 */
	public static Map<String, Object> doPut(String url, String param)
			throws IOException {
		CloseableHttpResponse response = null;
		HttpPut httpPut = new HttpPut(url);
		httpPut.setEntity(new StringEntity(param));
		Map<String, Object> ret = new HashMap<String, Object>();
		try {
			CloseableHttpClient httpclient = HttpClients.createDefault();
			response = httpclient.execute(httpPut);
			HttpEntity entity = response.getEntity();
			ret.put("HttpStatusCode", response.getStatusLine().getStatusCode());
			if (entity != null) {
				ret.put("response", IOUtils.toString(entity.getContent()));
			}
		} finally {
			IOUtils.closeQuietly((InputStream) response);
			httpPut.abort();
		}
		return ret;
	}

	public static Map<String, Object> putFile(String URLString, File file)
			throws IOException {
		CloseableHttpResponse response = null;
		Map<String, Object> ret = new HashMap<String, Object>();
		InputStream instream = null;
		HttpPut httpPut = new HttpPut(URLString);
		try {
			CloseableHttpClient httpclient = HttpClients.createDefault();
			FileEntity reqEntity = new FileEntity(file);
			httpPut.setEntity(reqEntity);
			response = httpclient.execute(httpPut);
			HttpEntity entity = response.getEntity();
			ret.put("HttpStatusCode", response.getStatusLine().getStatusCode());
			if (entity != null) {
				instream = entity.getContent();
				ret.putAll(jsonMapper.fromJson(
						IOUtils.toString(instream, "utf-8"), Map.class));
			}
		} finally {
			IOUtils.closeQuietly(instream);
			IOUtils.closeQuietly((InputStream) response);
			httpPut.abort();
		}
		return ret;
	}

	public static Map<String, Object> GetFile(String url, OutputStream output)
			throws IOException {
		CloseableHttpResponse response = null;
		InputStream input = null;
		Map<String, Object> ret = new HashMap<String, Object>();
		try {
			CloseableHttpClient httpclient = HttpClients.createDefault();
			HttpGet httpGet = new HttpGet(url);
			response = httpclient.execute(httpGet);
			HttpEntity entity = response.getEntity();
			if (entity != null) {
				ret.put("HttpStatusCode", response.getStatusLine()
						.getStatusCode());
				if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
					input = entity.getContent();
					IOUtils.copyLarge(input, output);
				} else {
					if (input != null)
						ret.putAll(jsonMapper.fromJson(
								IOUtils.toString(input, "utf-8"), Map.class));
				}
			}
		} finally {
			IOUtils.closeQuietly(input);
			IOUtils.closeQuietly(output);
			IOUtils.closeQuietly((InputStream) response);
		}
		return ret;
	}

	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

}
