package com.github.wxiaoqi.security.common.filter;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class AcceptFilter extends Filter<ILoggingEvent> {
	
	@Override
	public FilterReply decide(ILoggingEvent event) {
		if(event.getLoggerName().contains("Exception") || event.getLoggerName().contains("ERROR") || event.getLoggerName().startsWith("com.upyuns.platform.rs") || event.getLoggerName().startsWith("com.github.wxiaoqi") || event.getLoggerName().contains("Exception")) {
			return FilterReply.ACCEPT;
		} else {
			return FilterReply.DENY;
		}
	}
}