package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.UserInvoiceBiz;
import com.upyuns.platform.rs.website.dto.UserInvoiceDto;
import com.upyuns.platform.rs.website.entity.UserInvoice;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/userInvoice/web")
public class UserInvoiceWebController extends BaseController<UserInvoiceBiz,UserInvoice> {

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody UserInvoice userInvoice) {
		return baseBiz.userAddUpdate(userInvoice);
	}

	@GetMapping(value = "getUserList")
	public ObjectRestResponse getUserList(UserInvoiceDto userInvoiceDto) {
		return baseBiz.getUserInvoiceInfo(userInvoiceDto);
	}

	@PostMapping(value = "setDefault")
	public ObjectRestResponse setDefault(@RequestBody UserInvoice userInvoice) {
		return baseBiz.setDefault(userInvoice.getId());
	}

}