package com.upyuns.platform.rs.website.service;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.upyuns.platform.rs.datacenter.fegin.DatacenterFeign;
import com.upyuns.platform.rs.datacenter.pojo.ImageDataVO;
import com.upyuns.platform.rs.universal.constant.DictionaryKey;
import com.upyuns.platform.rs.universal.entity.Dictionary;
import com.upyuns.platform.rs.universal.feign.ThirdFeign;
import com.upyuns.platform.rs.website.biz.*;
import com.upyuns.platform.rs.website.dto.ConfirmOrderDto;
import com.upyuns.platform.rs.website.dto.ItemInfoDto;
import com.upyuns.platform.rs.website.entity.*;
import com.upyuns.platform.rs.website.type.OrderTypeEnum;
import com.upyuns.platform.rs.website.vo.ConfirmOrderInfoVo;
import com.upyuns.platform.rs.website.vo.ItemInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @ClassName : ConfirmOrderService
 * @Description : 确认订单信息
 * @Author : jiaoruizhen
 * @Date: 2020-12-16 14:50
 */
@Service
@Slf4j
public class ConfirmOrderService {

	@Autowired
	IndustryApplicationInfoBiz industryApplicationInfoBiz;

	@Autowired
	ImageImgStorageBiz imageImgStorageBiz;

	@Autowired
	ShoppingCartInfoBiz shoppingCartInfoBiz;

	@Autowired
	ImageInfoRelationBiz imageInfoRelationBiz;

	@Autowired
	ThirdFeign thirdFeign;

	@Autowired
	DatacenterFeign datacenterFeign;

	/**
	 * 确认订单
	 * @param confirmOrderDto
	 * @return
	 */
	public ObjectRestResponse confirmOrderInfo(ConfirmOrderDto confirmOrderDto) {
		if (confirmOrderDto == null || confirmOrderDto.getItemInfoDtoList() == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		ConfirmOrderInfoVo confirmOrderInfoVo = new ConfirmOrderInfoVo();
		List<ItemInfoDto> itemInfoDtoList = confirmOrderDto.getItemInfoDtoList();
		if (itemInfoDtoList != null && itemInfoDtoList.size() > 0) {
			List<ItemInfoVo> itemInfoVoList = new ArrayList<>();
			AtomicReference<Integer> number = new AtomicReference<>(0);
			AtomicReference<Double> amount = new AtomicReference<>((double) 0);
			itemInfoDtoList.parallelStream().forEach(itemInfoDto -> {
				switch (OrderTypeEnum.getByCode(itemInfoDto.getType())) {
					//标准数据
					case STANDARD_DATA:
						List<ImageDataVO> imageDataVOList = datacenterFeign.queryByIds(itemInfoDto.getId() + "").getData();
						if (imageDataVOList != null && imageDataVOList.size() > 0) {
							ImageDataVO imageDataVO = imageDataVOList.get(0);
							ItemInfoVo itemInfoVo = new ItemInfoVo();
							itemInfoVo.setId(Long.valueOf(imageDataVO.getId()));
							itemInfoVo.setDetailJson(JSONObject.toJSONString(imageDataVO));
							itemInfoVo.setNumber(itemInfoDto.getNumber());
							itemInfoVo.setType(itemInfoDto.getType());
							itemInfoVo.setPrice(imageDataVO.getPrice());
							itemInfoVoList.add(itemInfoVo);
							//总数量
							number.updateAndGet(v -> v + itemInfoDto.getNumber());
							BigDecimal totalAmount = imageDataVO.getPrice().multiply(new BigDecimal(itemInfoDto.getNumber()));
							amount.updateAndGet(v -> new Double((double) (v + totalAmount.doubleValue())));
						}
						break;
					//行业应用
					case INDUSTRY_INFO:
						IndustryApplicationInfo industryApplicationInfo = industryApplicationInfoBiz.getOneById(itemInfoDto.getId().intValue()).getData();
						if (industryApplicationInfo != null) {
							ItemInfoVo itemInfoVo = new ItemInfoVo();
							itemInfoVo.setId(Long.valueOf(industryApplicationInfo.getId()));
							itemInfoVo.setDetailJson(JSONObject.toJSONString(industryApplicationInfo));
							itemInfoVo.setImg(industryApplicationInfo.getCoverImg());
							itemInfoVo.setNumber(itemInfoDto.getNumber());
							itemInfoVo.setType(itemInfoDto.getType());
							itemInfoVo.setPrice(industryApplicationInfo.getPrice());
							itemInfoVo.setName(industryApplicationInfo.getTitle());
							itemInfoVoList.add(itemInfoVo);
							//总数量
							number.updateAndGet(v -> v + itemInfoDto.getNumber());
							BigDecimal totalAmount = industryApplicationInfo.getPrice().multiply(new BigDecimal(itemInfoDto.getNumber()));
							amount.updateAndGet(v -> new Double((double) (v + totalAmount.doubleValue())));
						}
						break;
					//影像图库
					case IMAGE_STORAGE:
						ImageInfoRelation imageInfoRelation = imageInfoRelationBiz.selectById(itemInfoDto.getId());
						if (imageInfoRelation != null ) {
							ImageImgStorage imageImgStorage = imageImgStorageBiz.getDetail(itemInfoDto.getId().intValue()).getData();
							if (imageImgStorage != null) {
								List<ImageInfoRelation> imageInfoRelationList = new ArrayList<>();
								imageInfoRelationList.add(imageInfoRelation);
								imageImgStorage.setImageInfoRelationList(imageInfoRelationList);
								ItemInfoVo itemInfoVo = new ItemInfoVo();
								itemInfoVo.setId(Long.valueOf(imageImgStorage.getId()));
								itemInfoVo.setPrice(imageInfoRelation.getPrice());
								itemInfoVo.setType(itemInfoDto.getType());
								itemInfoVo.setNumber(itemInfoDto.getNumber());
								itemInfoVo.setImg(imageImgStorage.getCoverImg());
								itemInfoVo.setDetailJson(JSONObject.toJSONString(imageImgStorage));
								itemInfoVo.setName(imageImgStorage.getName());
								itemInfoVoList.add(itemInfoVo);
								//总数量
								number.updateAndGet(v -> v + itemInfoDto.getNumber());
								BigDecimal totalAmount = imageInfoRelation.getPrice().multiply(new BigDecimal(itemInfoDto.getNumber()));
								amount.updateAndGet(v -> new Double((double) (v + totalAmount.doubleValue())));
							}
						}
						break;
					//购物车
					case SHOPPING_CART_INFO:
						ShoppingCartInfo shoppingCartInfo = shoppingCartInfoBiz.selectById(itemInfoDto.getId());
						if (shoppingCartInfo != null) {
							ItemInfoVo itemInfoVo = new ItemInfoVo();
							itemInfoVo.setId(shoppingCartInfo.getCartId());
							itemInfoVo.setPrice(shoppingCartInfo.getPrice());
							itemInfoVo.setType(shoppingCartInfo.getType());
							itemInfoVo.setNumber(itemInfoDto.getNumber());
							itemInfoVo.setImg(shoppingCartInfo.getItemPic());
							itemInfoVo.setDetailJson(shoppingCartInfo.getDetailJson());
							itemInfoVo.setName(shoppingCartInfo.getName());
							itemInfoVoList.add(itemInfoVo);
							number.updateAndGet(v -> v + itemInfoDto.getNumber());
							BigDecimal totalAmount = shoppingCartInfo.getTotalAmount();
							amount.updateAndGet(v -> new Double((double) (v + totalAmount.doubleValue())));
						}
						break;
					default:
						break;
				}
			});
			confirmOrderInfoVo.setTotalAmount(new BigDecimal(amount.get()));
			confirmOrderInfoVo.setNumber(number.get());
			confirmOrderInfoVo.setItemInfoVoList(itemInfoVoList);
		}


		Dictionary dictionary = thirdFeign.findDictionaryByTypeAndCode(DictionaryKey.APP_ORDER, DictionaryKey.SEND_FEE);
		if (dictionary != null && StringUtils.isNotBlank(dictionary.getDetail())) {
			confirmOrderInfoVo.setFee(new BigDecimal(dictionary.getDetail()));
		}
		if (confirmOrderInfoVo.getFee() != null) {
			confirmOrderInfoVo.setActAmount(confirmOrderInfoVo.getTotalAmount().add(confirmOrderInfoVo.getFee()));
		}
		return ObjectRestResponse.succ(confirmOrderInfoVo);
	}

}
