package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.OrderInfoBiz;
import com.upyuns.platform.rs.website.dto.*;
import com.upyuns.platform.rs.website.entity.OrderInfo;
import com.upyuns.platform.rs.website.service.ConfirmOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("orderInfo/web")
public class OrderInfoWebController extends BaseController<OrderInfoBiz,OrderInfo> implements UserRestInterface {

	@Autowired
	ConfirmOrderService confirmOrderService;

	@Autowired
	UserFeign userFeign;

	@PostMapping(value = "confirmOrder")
	public ObjectRestResponse confirmOrder(@RequestBody ConfirmOrderDto confirmOrderDto) {
		return confirmOrderService.confirmOrderInfo(confirmOrderDto);
	}

	@PostMapping(value = "submitOrder")
	public ObjectRestResponse submitOrder(@RequestBody OrderInfoDto orderInfoDto) {
		return baseBiz.submitOrder(orderInfoDto);
	}

	@GetMapping(value = "getOrderList")
	public ObjectRestResponse getUserOrder(UserOrderDto userOrderDto) {
		userOrderDto.setUserId(getAppUser().getUserid());
		return baseBiz.getUserOrder(userOrderDto);
	}

	@GetMapping(value = "detail")
	public ObjectRestResponse getDetail(Long id) {
		return ObjectRestResponse.succ(baseBiz.getOrderDetail(id));
	}

	@GetMapping(value = "confirmReceived")
	public ObjectRestResponse confirmReceived(Long orderId) {
		return baseBiz.confirmReceived(orderId);
	}

	@GetMapping(value = "confirmOrderInvoice")
	public ObjectRestResponse confirmOrderInvoice(Long orderId) {
		return baseBiz.confirmOrderInvoice(orderId);
	}

	@PostMapping(value = "cancelOrder")
	public ObjectRestResponse cancelOrder(@RequestBody OrderInfo orderInfo) {
		return baseBiz.cancelOrder(orderInfo);
	}

	@DeleteMapping(value = "deleteOrder")
	public ObjectRestResponse deleteOrder(Long orderId) {
		return baseBiz.deleteOrder(orderId);
	}

	@PostMapping(value = "setAddressOrInvoice")
	public ObjectRestResponse setAddressOrInvoice(@RequestBody OrderInfoDto orderInfoDto) {
		return baseBiz.setAddressOrInvoice(orderInfoDto);
	}

	@Override
	public UserFeign getUserFeign() {
		return userFeign;
	}
}