package com.upyuns.platform.rs.website.controller.web;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.AssertUtils;
import com.github.wxiaoqi.security.common.util.ReflectionUtils;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.upyuns.platform.rs.datacenter.fegin.DatacenterFeign;
import com.upyuns.platform.rs.website.biz.CustomFormBiz;
import com.upyuns.platform.rs.website.dto.custom.CustomQueryDTO;
import com.upyuns.platform.rs.website.entity.CustomForm;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.Field;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("customForm/web")
public class CustomFormWebController extends BaseController<CustomFormBiz,CustomForm> implements UserRestInterface {

    @Autowired
    UserFeign userFeign;

    @Autowired
    DatacenterFeign datacenterFegin;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    @RequestMapping(value = "customIndustry",method = RequestMethod.POST)
    public ObjectRestResponse customIndustry(@RequestBody CustomForm entity) {
        if(StrUtil.isNotBlank(entity.getProvinceCode())) {
            entity.setProvinceName(datacenterFegin.queryByCode(entity.getProvinceCode()).getData().getName());
        }
        if(StrUtil.isNotBlank(entity.getCityCode())) {
            entity.setCityName(datacenterFegin.queryByCode(entity.getCityCode()).getData().getName());
        }
        if(StrUtil.isNotBlank(entity.getAreaCode())) {
            entity.setAreaName(datacenterFegin.queryByCode(entity.getAreaCode()).getData().getName());
        }
        entity.setUserId(getAppUser().getUserid());
        entity.setType(CustomForm.TYPE_INDUSTRY);
        baseBiz.insertSelective(entity);
        return ObjectRestResponse.succ();
    }

    @RequestMapping(value = "customImgStorage",method = RequestMethod.POST)
    public ObjectRestResponse customImgStorage(@RequestBody CustomForm entity) {
        if(StrUtil.isNotBlank(entity.getProvinceCode())) {
            entity.setProvinceName(datacenterFegin.queryByCode(entity.getProvinceCode()).getData().getName());
        }
        if(StrUtil.isNotBlank(entity.getCityCode())) {
            entity.setCityName(datacenterFegin.queryByCode(entity.getCityCode()).getData().getName());
        }
        if(StrUtil.isNotBlank(entity.getAreaCode())) {
            entity.setAreaName(datacenterFegin.queryByCode(entity.getAreaCode()).getData().getName());
        }
        entity.setUserId(getAppUser().getUserid());
        entity.setType(CustomForm.TYPE_STORAGE);
        baseBiz.insertSelective(entity);
        return ObjectRestResponse.succ();
    }

    @RequestMapping(value = "customImageData",method = RequestMethod.POST)
    public ObjectRestResponse customImageData(@RequestBody CustomForm entity) {
        if(StrUtil.isNotBlank(entity.getProvinceCode())) {
            entity.setProvinceName(datacenterFegin.queryByCode(entity.getProvinceCode()).getData().getName());
        }
        if(StrUtil.isNotBlank(entity.getCityCode())) {
            entity.setCityName(datacenterFegin.queryByCode(entity.getCityCode()).getData().getName());
        }
        if(StrUtil.isNotBlank(entity.getAreaCode())) {
            entity.setAreaName(datacenterFegin.queryByCode(entity.getAreaCode()).getData().getName());
        }
        entity.setUserId(getAppUser().getUserid());
        entity.setType(CustomForm.TYPE_IMAGE);
        baseBiz.insertSelective(entity);
        return ObjectRestResponse.succ();
    }

    @RequestMapping(value = "myCustoms",method = RequestMethod.GET)
    public ObjectRestResponse<PageDataVO<CustomForm>> myCustoms(CustomQueryDTO dto) {
        return ObjectRestResponse.succ(PageDataVO.pageInfo(dto.initQuery(), () -> baseBiz.selectByWeekend(w -> {
            w.andEqualTo(CustomForm::getUserId, getAppUser().getUserid());
            w.andEqualTo(CustomForm::getIsDel, SYS_FALSE);
            if(null != dto.getType()) {
                w.andEqualTo(CustomForm::getType, dto.getType());
            }
            return w;
        }, " crt_time desc")));
    }

    @ApiOperation("删除")
    @RequestMapping(value = "/delCustom",method = RequestMethod.DELETE)
    @ResponseBody
    public ObjectRestResponse delCustom(@RequestBody CustomForm entity){
        CustomForm db = baseBiz.selectById(entity.getId());
        if(CustomForm.STATUS_SUBMIT != db.getStatus()) {
            throw new BaseException("该定制不能删除", ResultCode.PARAM_ILLEGAL_CODE);
        }
        entity.setIsDel(SYS_TRUE);
        baseBiz.updateSelectiveById(entity);
        return ObjectRestResponse.succ();
    }

}