package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.OrderInfoBiz;
import com.upyuns.platform.rs.website.dto.*;
import com.upyuns.platform.rs.website.entity.CustomForm;
import com.upyuns.platform.rs.website.entity.OrderInfo;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("orderInfo")
public class OrderInfoController extends BaseController<OrderInfoBiz,OrderInfo> {

	@GetMapping(value = "getOrderList")
	public ObjectRestResponse getOrderList(UserOrderDto userOrderDto) {
		return baseBiz.getOrderList(userOrderDto);
	}

	@GetMapping(value = "detail")
	public ObjectRestResponse detail(Long orderId) {
		return ObjectRestResponse.succ(baseBiz.getOrderDetail(orderId));
	}

	@PostMapping(value = "orderSend")
	public ObjectRestResponse orderSend(@RequestBody ConfirmReceivedDto confirmReceivedDto) {
		return baseBiz.orderSend(confirmReceivedDto);
	}

	@PostMapping(value = "setInvoice")
	public ObjectRestResponse setInvoice(@RequestBody OrderInvoiceDto orderInvoiceDto) {
		return baseBiz.setInvoice(orderInvoiceDto);
	}

	@PostMapping(value = "invoiceSend")
	public ObjectRestResponse invoiceSend(@RequestBody ConfirmReceivedDto confirmReceivedDto) {
		return baseBiz.invoiceSend(confirmReceivedDto);
	}

	@PostMapping(value = "customerToOrderInfo")
	public ObjectRestResponse customerToOrderInfo(@RequestBody CustomFormDto customFormDto) {
		return baseBiz.customerToOrderInfo(customFormDto);
	}

	@PostMapping(value = "setOrderPrice")
	public ObjectRestResponse setOrderPrice(@RequestBody OrderInfo orderInfo) {
		return baseBiz.setOrderPrice(orderInfo);
	}

	@PostMapping(value = "setOrderItem")
	public ObjectRestResponse setOrderItem(@RequestBody OrderInfoDto orderInfoDto) {
		return baseBiz.setOrderItem(orderInfoDto);
	}

	@GetMapping(value = "getItemByType")
	public ObjectRestResponse getItemByType(Integer type, String name) {
		return baseBiz.getItemByType(type, name);
	}

}