package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 订单信息
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Data
@Table(name = "order_info")
public class OrderInfo implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 *
	 */
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
	private Long orderId;

	/**
	 * 订单号
	 */
	@Column(name = "order_no")
	@ApiModelProperty(value = "订单号")
	private String orderNo;

	/**
	 * 单价
	 */
	@Column(name = "amount")
	@ApiModelProperty(value = "单价")
	private BigDecimal amount;

	/**
	 * 数量
	 */
	@Column(name = "number")
	@ApiModelProperty(value = "数量")
	private Integer number;

	/**
	 * 订单状态：0、定制订单无价格  1--创建订单，2--待付款，3--已支付，4--已发货, 5--已收货, 6、已完成 -1、删除，-2、取消, -3 退款
	 */
	@Column(name = "status")
	@ApiModelProperty(value = " 订单状态：0、定制订单无价格  1--创建订单，2--待付款，3--已支付，4--已发货, 5--已收货, 6、已完成 -1、删除，-2、取消, -3 退款")
	private Integer status;

	/**
	 * 发货状态0待发货，1已发货，2收货，3退货,
	 */
	private Integer shippingStatus;

	/**
	 * 1待付款，2已付款，3已退款
	 */
	private Integer payStatus;

	/**
	 * 用户id
	 */
	@Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
	private Integer userId;

	/**
	 * 用户手机号
	 */
	@Column(name = "phone")
	@ApiModelProperty(value = "用户手机号")
	private String phone;

	/**
	 * 用户昵称
	 */
	@Column(name = "nickname")
	@ApiModelProperty(value = "用户昵称")
	private String nickname;

	/**
	 * 用户真实姓名
	 */
	@Column(name = "real_name")
	@ApiModelProperty(value = "用户真实姓名")
	private String realName;

	/**
	 * 头像
	 */
	@Column(name = "head_img")
	@ApiModelProperty(value = "头像")
	private String headImg;

	/**
	 * 1、微信支付，2、支付宝支付，3、对公支付
	 */
	@Column(name = "pay_type")
	@ApiModelProperty(value = "1、微信支付，2、支付宝支付，3、对公支付")
	private Integer payType;

	/**
	 * 下单时间
	 */
	@Column(name = "crt_time")
	@ApiModelProperty(value = "下单时间", hidden = true)
	private Date crtTime;

	/**
	 * 支付时间
	 */
	@Column(name = "pay_time")
	@ApiModelProperty(value = "支付时间")
	private Date payTime;

	/**
	 *
	 */
	@Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true)
	private Date updTime;

	/**
	 * 运费
	 */
	@Column(name = "fee")
	@ApiModelProperty(value = "运费")
	private BigDecimal fee;

	/**
	 * 订单备注
	 */
	@Column(name = "remark")
	@ApiModelProperty(value = "订单备注")
	private String remark;

	/**
	 * 配送方式:1、线上配送，2、快递配送
	 */
	@Column(name = "send_type")
	@ApiModelProperty(value = "配送方式:1、线上配送，2、快递配送")
	private Integer sendType;

	/**
	 * 收货人姓名
	 */
	@Column(name = "receive_name")
	@ApiModelProperty(value = "收货人姓名")
	private String receiveName;

	/**
	 * 收货人电话
	 */
	@Column(name = "receive_phone")
	@ApiModelProperty(value = "收货人电话")
	private String receivePhone;

	/**
	 * 收货地址
	 */
	@Column(name = "receive_address")
	@ApiModelProperty(value = "收货地址")
	private String receiveAddress;

	/**
	 * 总金额
	 */
	@Column(name = "total_amount")
	@ApiModelProperty(value = "")
	private BigDecimal totalAmount;

	/**
	 * 1、普通订单，2、定制订单
	 */
	@Column(name = "type")
	@ApiModelProperty(value = "1、普通订单，2、定制订单")
	private Integer type;

	/**
	 * 发票状态： 1、未开发票，2、已开发票, 3、已发货， 4、已收货、5、退回， 6、已完成
	 */
	private Integer invoiceStatus;

	/**
	 * 发票ID
	 */
	private Integer invoiceId;

	/**
	 * 快递单号
	 */
	String trackingNumber;

	/**
	 * 快递单图片
	 */
	String trackingImg;

	/**
	 * 取消备注
	 */
	String cancelRemark;

	/**
	 * 定制订单ID
	 */
	Integer customerId;

	/**
	 * 定制信息json
	 */
	String customerJson;

	@Transient
	private List<OrderItem> orderItemList;

	@Transient
	OrderEInvoice orderEInvoice;
}
