package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.collection.CollUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.datacenter.biz.RscpImagePriceBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpResolutionBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import com.upyuns.platform.rs.datacenter.entity.RscpResolution;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("/web/resolution")
public class RscpResolutionController extends BaseController<RscpResolutionBiz, RscpResolution> {


    @RequestMapping(value = "/app/unauth/all", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse unauthQuery() {

        List<RscpResolution> list = baseBiz.selectByWeekend(w -> {
            w.andEqualTo(RscpResolution::getStatus, SYS_TRUE);
            w.andEqualTo(RscpResolution::getIsDel, SYS_FALSE);
            return w;
        }, " sort asc");

        return ObjectRestResponse.succ(list);
    }

}