package com.upyuns.platform.rs.datacenter.mqhandler;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONUtil;
import com.rabbitmq.client.Channel;
import com.upyuns.platform.rs.datacenter.biz.RscpImageDataTotalBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImageInputLogBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImageInputLog;
import com.upyuns.platform.rs.datacenter.vo.ImageInputVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static com.upyuns.platform.rs.datacenter.config.RabbitConfig.IMAGE_INPUT_LOG_QUEUE;

@Component
@Slf4j
public class ImageInputLogMQHandler {

    @Autowired
    RscpImageInputLogBiz rscpImageInputLogBiz;

    @Autowired
    RscpImageDataTotalBiz rscpImageDataTotalBiz;

    /**
     * 同步门店信息
     * @param
     */
    @RabbitListener(queues = IMAGE_INPUT_LOG_QUEUE)
    public void integralHandler(Message message, @Headers Map<String, Object> headers, Channel channel) {
        log.info("同步门店信息 messageJson："+ JSONUtil.parse(message));
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(() -> {
            try {
                String messageId = message.getMessageProperties().getMessageId();
                String msg = new String(message.getBody(), "UTF-8");
                ImageInputVO ii = JSONUtil.toBean(msg, ImageInputVO.class);
                RscpImageInputLog insertLog = new RscpImageInputLog(){{
                    setContextJson(JSONUtil.toJsonStr(ii));
                    setStatus(STATU_ING);
                }};
                rscpImageInputLogBiz.insertSelective(insertLog);
                executorService.shutdown();
                Long deliveryTag = (Long) headers.get(AmqpHeaders.DELIVERY_TAG);
                // 手动签收
                channel.basicAck(deliveryTag, false);
                ExecutorService executorService2 = Executors.newCachedThreadPool();
                executorService2.execute(() -> {
                    try {
                        //查询数据是否存在
                        Long count = rscpImageDataTotalBiz.selectCount(new RscpImageDataTotal(){{
                            setName(ii.getName());
                        }});

//                        ImageTotalInputDTO imageTotalInputDTO = BeanUtil.toBean(ii, ImageTotalInputDTO.class);
//                        //生成几何范围


                        if(count > 0L) {
                            //更新
                        }

                    }catch (Exception e) {
                        log.error(e.getMessage(), e);
                        throw e;
                    }
                });
            } catch (Exception e) {
                log.info("接收到的消息失败");
                try {
                    channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                } catch (IOException i) {
                    log.error(e.getMessage(), i);
                }
                log.error(e.getMessage(), e);
            }
        });
    }
}
