package com.upyuns.platform.rs.datacenter.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import tk.mybatis.mapper.annotation.KeySql;

import javax.persistence.*;
import java.math.BigDecimal;
import java.sql.Timestamp;

@Data
@Table(name = "rscp_image_price")
@ApiModel(description = "影像数据单价表")
public class RscpImagePrice implements java.io.Serializable {
    /** 版本号 */
    private static final long serialVersionUID = 1324632775380935758L;

    /* This code was generated by TableGo tools, mark 1 begin. */

    /** 标识 */
    @Id
    @KeySql(useGeneratedKeys = true)
    @Column(name = "id",insertable = false)
    @ApiModelProperty(value = "标识")
    private Integer id;

    /** 卫星 */
    @ApiModelProperty(value = "卫星")
    private String imageSatelliteType;

    /** 分辨率 */
    @ApiModelProperty(value = "分辨率")
    private String imageResolution;

    /** 光谱 */
    @ApiModelProperty(value = "光谱")
    private String imageSpectrumType;

    /** 单价 */
    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    /** 优惠 */
    @ApiModelProperty(value = "优惠")
    private BigDecimal discount;

    /** 更新人 */
    @ApiModelProperty(value = "更新人")
    private String updName;

    /** 更新时间 */
    @ApiModelProperty(value = "更新时间")
    private Timestamp updTime;

    /** 产品类型 0101 原始 0102 正射 */
    @ApiModelProperty(value = "产品类型 0101 原始 0102 正射")
    private String imageProductType;

    /** 每景单价 */
    @ApiModelProperty(value = "每景单价")
    private BigDecimal unitPrice;

    /** 传感器类型 */
    @ApiModelProperty(value = "传感器类型")
    private String imageSensorType;

    /** 是否应用于数据定制 */
    @ApiModelProperty(value = "是否应用于数据定制")
    private Integer isUseForData;

    /**  状态。0 不可用， 1可用 */
    @ApiModelProperty(value = " 状态。0 不可用， 1可用")
    private Integer status;

    /** 卫星全称 */
    @ApiModelProperty(value = "卫星全称")
    private String satelliteName;

    /** 传感器全称 */
    @ApiModelProperty(value = "传感器全称")
    private String sensorName;

    /**  数据类型  定制化 */
    @ApiModelProperty(value = " 数据类型  定制化")
    private String dataType;

    /** 是否在每日最新里显示：0 不显示，1 显示 */
    @ApiModelProperty(value = "是否在每日最新里显示：0 不显示，1 显示")
    private Integer dailyDisplay;

    /** 每日最新的排序 */
    @ApiModelProperty(value = "每日最新的排序")
    private Integer dailySort;

    /** 销售状态 0下架 1上架 */
    @ApiModelProperty(value = "销售状态 0下架 1上架")
    private Integer isSell;

    /** 首页排序 */
    @ApiModelProperty(value = "首页排序")
    private Integer indexSort;

    /** 是否要首页显示：0否，1是 */
    @ApiModelProperty(value = "是否要首页显示：0否，1是")
    private Integer isIndex;

    /* This code was generated by TableGo tools, mark 1 end. */

    /* This code was generated by TableGo tools, mark 2 begin. */

    /**
     * 获取标识
     * 
     * @return 标识
     */
    public Integer getId() {
        return this.id;
    }

    /**
     * 设置标识
     * 
     * @param id
     *          标识
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取卫星
     * 
     * @return 卫星
     */
    public String getImageSatelliteType() {
        return this.imageSatelliteType;
    }

    /**
     * 设置卫星
     * 
     * @param imageSatelliteType
     *          卫星
     */
    public void setImageSatelliteType(String imageSatelliteType) {
        this.imageSatelliteType = imageSatelliteType;
    }

    /**
     * 获取分辨率
     * 
     * @return 分辨率
     */
    public String getImageResolution() {
        return this.imageResolution;
    }

    /**
     * 设置分辨率
     * 
     * @param imageResolution
     *          分辨率
     */
    public void setImageResolution(String imageResolution) {
        this.imageResolution = imageResolution;
    }

    /**
     * 获取光谱
     * 
     * @return 光谱
     */
    public String getImageSpectrumType() {
        return this.imageSpectrumType;
    }

    /**
     * 设置光谱
     * 
     * @param imageSpectrumType
     *          光谱
     */
    public void setImageSpectrumType(String imageSpectrumType) {
        this.imageSpectrumType = imageSpectrumType;
    }

    /**
     * 获取单价
     * 
     * @return 单价
     */
    public BigDecimal getPrice() {
        return this.price;
    }

    /**
     * 设置单价
     * 
     * @param price
     *          单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    /**
     * 获取优惠
     * 
     * @return 优惠
     */
    public BigDecimal getDiscount() {
        return this.discount;
    }

    /**
     * 设置优惠
     * 
     * @param discount
     *          优惠
     */
    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    /**
     * 获取更新人
     * 
     * @return 更新人
     */
    public String getUpdName() {
        return this.updName;
    }

    /**
     * 设置更新人
     * 
     * @param updName
     *          更新人
     */
    public void setUpdName(String updName) {
        this.updName = updName;
    }

    /**
     * 获取更新时间
     * 
     * @return 更新时间
     */
    public Timestamp getUpdTime() {
        return this.updTime;
    }

    /**
     * 设置更新时间
     * 
     * @param updTime
     *          更新时间
     */
    public void setUpdTime(Timestamp updTime) {
        this.updTime = updTime;
    }

    /**
     * 获取产品类型 0101 原始 0102 正射
     * 
     * @return 产品类型 0101 原始 0102 正射
     */
    public String getImageProductType() {
        return this.imageProductType;
    }

    /**
     * 设置产品类型 0101 原始 0102 正射
     * 
     * @param imageProductType
     *          产品类型 0101 原始 0102 正射
     */
    public void setImageProductType(String imageProductType) {
        this.imageProductType = imageProductType;
    }

    /**
     * 获取每景单价
     * 
     * @return 每景单价
     */
    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    /**
     * 设置每景单价
     * 
     * @param unitPrice
     *          每景单价
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    /**
     * 获取传感器类型
     * 
     * @return 传感器类型
     */
    public String getImageSensorType() {
        return this.imageSensorType;
    }

    /**
     * 设置传感器类型
     * 
     * @param imageSensorType
     *          传感器类型
     */
    public void setImageSensorType(String imageSensorType) {
        this.imageSensorType = imageSensorType;
    }

    /**
     * 获取是否应用于数据定制
     * 
     * @return 是否应用于数据定制
     */
    public Integer getIsUseForData() {
        return this.isUseForData;
    }

    /**
     * 设置是否应用于数据定制
     * 
     * @param isUseForData
     *          是否应用于数据定制
     */
    public void setIsUseForData(Integer isUseForData) {
        this.isUseForData = isUseForData;
    }

    /**
     * 获取 状态。0 不可用， 1可用
     * 
     * @return  状态。0 不可用
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置 状态。0 不可用， 1可用
     * 
     * @param status
     *           状态。0 不可用
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取卫星全称
     * 
     * @return 卫星全称
     */
    public String getSatelliteName() {
        return this.satelliteName;
    }

    /**
     * 设置卫星全称
     * 
     * @param satelliteName
     *          卫星全称
     */
    public void setSatelliteName(String satelliteName) {
        this.satelliteName = satelliteName;
    }

    /**
     * 获取传感器全称
     * 
     * @return 传感器全称
     */
    public String getSensorName() {
        return this.sensorName;
    }

    /**
     * 设置传感器全称
     * 
     * @param sensorName
     *          传感器全称
     */
    public void setSensorName(String sensorName) {
        this.sensorName = sensorName;
    }

    /**
     * 获取 数据类型  定制化
     * 
     * @return  数据类型  定制化
     */
    public String getDataType() {
        return this.dataType;
    }

    /**
     * 设置 数据类型  定制化
     * 
     * @param dataType
     *           数据类型  定制化
     */
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    /**
     * 获取是否在每日最新里显示：0 不显示，1 显示
     * 
     * @return 是否在每日最新里显示：0 不显示
     */
    public Integer getDailyDisplay() {
        return this.dailyDisplay;
    }

    /**
     * 设置是否在每日最新里显示：0 不显示，1 显示
     * 
     * @param dailyDisplay
     *          是否在每日最新里显示：0 不显示
     */
    public void setDailyDisplay(Integer dailyDisplay) {
        this.dailyDisplay = dailyDisplay;
    }

    /**
     * 获取每日最新的排序
     * 
     * @return 每日最新的排序
     */
    public Integer getDailySort() {
        return this.dailySort;
    }

    /**
     * 设置每日最新的排序
     * 
     * @param dailySort
     *          每日最新的排序
     */
    public void setDailySort(Integer dailySort) {
        this.dailySort = dailySort;
    }

    /**
     * 获取销售状态 0下架 1上架
     * 
     * @return 销售状态 0下架 1上架
     */
    public Integer getIsSell() {
        return this.isSell;
    }

    /**
     * 设置销售状态 0下架 1上架
     * 
     * @param isSell
     *          销售状态 0下架 1上架
     */
    public void setIsSell(Integer isSell) {
        this.isSell = isSell;
    }

    /**
     * 获取首页排序
     * 
     * @return 首页排序
     */
    public Integer getIndexSort() {
        return this.indexSort;
    }

    /**
     * 设置首页排序
     * 
     * @param indexSort
     *          首页排序
     */
    public void setIndexSort(Integer indexSort) {
        this.indexSort = indexSort;
    }

    /**
     * 获取是否要首页显示：0否，1是
     * 
     * @return 是否要首页显示：0否
     */
    public Integer getIsIndex() {
        return this.isIndex;
    }

    /**
     * 设置是否要首页显示：0否，1是
     * 
     * @param isIndex
     *          是否要首页显示：0否
     */
    public void setIsIndex(Integer isIndex) {
        this.isIndex = isIndex;
    }

    /* This code was generated by TableGo tools, mark 2 end. */
}