package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.NoticeInfoBiz;
import com.upyuns.platform.rs.website.dto.NoticeInfoDto;
import com.upyuns.platform.rs.website.entity.NoticeInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("noticeInfo/web")
public class NoticeInfoWebController extends BaseController<NoticeInfoBiz,NoticeInfo> implements UserRestInterface {

	@Autowired
	UserFeign userFeign;

	@Override
	public UserFeign getUserFeign() {
		return userFeign;
	}

	@GetMapping(value = "getAllByUser")
	public ObjectRestResponse getUserList(NoticeInfoDto noticeInfoDto) {
		noticeInfoDto.setUserId(Integer.parseInt(getCurrentUserId()));
		return baseBiz.getByUserId(noticeInfoDto);
	}

	@DeleteMapping(value = "deleteOne")
	public ObjectRestResponse deleteOne(Integer id) {
		return baseBiz.deleteOne(id);
	}

	@PostMapping(value = "updateRead")
	public ObjectRestResponse updateRead(@RequestBody NoticeInfo noticeInfo) {
		return baseBiz.updateRead(noticeInfo.getId());
	}

	@PostMapping(value = "updateAllRead")
	public ObjectRestResponse updateAllRead(@RequestBody NoticeInfoDto noticeInfoDto) {
		return baseBiz.updateAllRead(noticeInfoDto.getIds());
	}

	@PostMapping(value = "updateAll")
	public ObjectRestResponse updateAll(@RequestBody NoticeInfoDto noticeInfoDto) {
		noticeInfoDto.setUserId(Integer.parseInt(getCurrentUserId()));
		return baseBiz.updateAll(noticeInfoDto);
	}
}