package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.IndustryApplicationInfoDto;
import com.upyuns.platform.rs.website.dto.IndustryApplicationTypeDto;
import com.upyuns.platform.rs.website.entity.IndustryApplicationInfo;
import com.upyuns.platform.rs.website.entity.IndustryApplicationType;
import com.upyuns.platform.rs.website.mapper.IndustryApplicationInfoMapper;
import com.upyuns.platform.rs.website.vo.IndustryTypeVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 行业应用信息
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:29
 */
@Service
public class IndustryApplicationInfoBiz extends BaseBiz<IndustryApplicationInfoMapper, IndustryApplicationInfo> {

	@Autowired
	IndustryApplicationTypeBiz industryApplicationTypeBiz;

	/**
	 * 行业应用信息
	 * @param industryApplicationInfo
	 * @return
	 */
	public ObjectRestResponse addObj(IndustryApplicationInfo industryApplicationInfo) {
		if (industryApplicationInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (industryApplicationInfo.getId() != null) {
			IndustryApplicationInfo old = selectById(industryApplicationInfo.getId());
			if (old == null || old.getIsDel() == 1) {
				return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
			}
			BeanUtil.copyProperties(industryApplicationInfo, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		} else {
			insertSelectiveRe(industryApplicationInfo);
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 根据id查询详情
	 * @param id
	 * @return
	 */
	public ObjectRestResponse<IndustryApplicationInfo> getOneById(Integer id) {
		IndustryApplicationInfo old = selectById(id);
		if (old == null || old.getIsDel() == 1) {
			return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
		}
		return ObjectRestResponse.succ(old);
	}

	/**
	 * 查询列表
	 * @param industryApplicationInfoDto
	 * @return
	 */
	public ObjectRestResponse<PageDataVO<IndustryApplicationInfo>> selectList(IndustryApplicationInfoDto industryApplicationInfoDto) {
		Query query = new Query(industryApplicationInfoDto);
		PageDataVO<IndustryApplicationInfo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
		return ObjectRestResponse.succ(pageDataVO);
	}

	/**
	 * 获取首页展示数据
	 * @return
	 */
	public ObjectRestResponse<List<IndustryTypeVo>> getAllIndexShow() {
		List<IndustryTypeVo> list = new ArrayList<>();
		List<IndustryApplicationType> industryApplicationTypeList = industryApplicationTypeBiz.getAll(1).getData();
		if (industryApplicationTypeList != null && industryApplicationTypeList.size() > 0) {
				Map<Integer, List<IndustryApplicationType>> map = industryApplicationTypeList.stream().collect(Collectors.groupingBy(IndustryApplicationType::getId));
			Example example = new Example(IndustryApplicationInfo.class);
			example.createCriteria().andEqualTo("isDel", 0).andEqualTo("status", 1).andEqualTo("indexShow", 1).andIn("firstTypeId", map.keySet());
			example.orderBy("rank");
			List<IndustryApplicationInfo> industryApplicationInfoList = mapper.selectByExample(example);
			if (industryApplicationInfoList != null && industryApplicationInfoList.size() > 0) {
				industryApplicationInfoList.stream().forEach(industryApplicationInfo -> {
					if (map.get(industryApplicationInfo.getFirstTypeId()) != null && map.get(industryApplicationInfo.getFirstTypeId()).size() > 0) {
						IndustryApplicationType industryApplicationType = map.get(industryApplicationInfo.getFirstTypeId()).get(0);
						IndustryTypeVo industryTypeVo = new IndustryTypeVo();
						BeanUtil.copyProperties(industryApplicationType, industryTypeVo, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
						industryTypeVo.setIndustryApplicationInfo(industryApplicationInfo);
						list.add(industryTypeVo);
					}
				});
			}
		}
		return ObjectRestResponse.succ(list);
	}

	/**
	 * 根据ID List获取行业应用信息
	 * @param idList
	 * @return
	 */
	public List<IndustryApplicationInfo> getAllByIds(Set<Integer> idList) {
		Example example = new Example(IndustryApplicationInfo.class);
		example.createCriteria().andIn("id", idList);
		return mapper.selectByExample(example);
	}


	/**
	 * 根据参数查询行业应用信息
	 * @param industryApplicationInfo
	 * @return
	 */
	public List<IndustryApplicationInfo> getAllByParam(IndustryApplicationInfo industryApplicationInfo) {
		Example example = new Example(IndustryApplicationInfo.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isDel", 0).andEqualTo("status", 1);
		if (industryApplicationInfo.getFirstTypeId() != null) {
			criteria.andEqualTo("firstTypeId", industryApplicationInfo.getFirstTypeId()).orEqualTo("secondTypeId", industryApplicationInfo.getFirstTypeId());
		}
		return mapper.selectByExample(example);
	}

	/**
	 * 获取所有行业应用
	 * @return
	 */
	public List<IndustryApplicationInfo> getAllData(String name) {
		Example example = new Example(IndustryApplicationInfo.class);
		Example.Criteria criteria = example.createCriteria();
		if (StringUtils.isNotBlank(name)) {
			criteria.andLike("title", "%" + name + "");
		}
		criteria.andEqualTo("isDel", 0).andEqualTo("status", 1);
		return mapper.selectByExample(example);
	}

}