package com.upyuns.platform.rs.website.biz;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.ImageInfoRelationDto;
import com.upyuns.platform.rs.website.entity.ImageImgStorage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.ImageInfoRelation;
import com.upyuns.platform.rs.website.mapper.ImageInfoRelationMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 影像图库上传图片关联信息
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-04 14:38:23
 */
@Service
public class ImageInfoRelationBiz extends BaseBiz<ImageInfoRelationMapper,ImageInfoRelation> {


	public void addUpdate(ImageInfoRelation imageInfoRelation) {
		if (imageInfoRelation.getId() != null) {
			updateSelectiveByIdRe(imageInfoRelation);
		} else {
			insertSelectiveRe(imageInfoRelation);
		}
	}

	public void deleteAll(Integer relationId) {
		List<ImageInfoRelation> list = selectList(new ImageInfoRelation(){{setRelationId(relationId);setType(1);}});
		if (list != null) {
			list.stream().forEach(imageInfoRelation -> {
				delete(imageInfoRelation);
			});
		}
	}

	/**
	 * 返回带图片
	 * @param relationId
	 * @param type
	 * @return
	 */
	public List<ImageInfoRelation> getAllById(Integer relationId, Integer type) {
		Example example = new Example(ImageInfoRelation.class);
		example.createCriteria().andEqualTo("relationId", relationId).andEqualTo("type", type);
		List<ImageInfoRelation> list = mapper.selectByExample(example);
		return list;
	}

	/**
	 * 查询影像图框图片类型， 返回不带图片
	 * @param relationId
	 * @param type
	 * @return
	 */
	public List<ImageInfoRelation> getAllImageRelation(Integer relationId, Integer type) {
		Example example = new Example(ImageInfoRelation.class);
		example.createCriteria().andEqualTo("relationId", relationId).andEqualTo("type", type);
		List<ImageInfoRelation> list = mapper.selectByExample(example);
		if (list != null && list.size() > 0) {
			list.stream().forEach(imageInfoRelation -> {
				imageInfoRelation.setUrl(null);
			});
			return list;
		}
		return new ArrayList<>();
	}

	/**
	 * 根据影像尺寸查询对应图像信息
	 * @param relationId
	 * @param type
	 * @param fileWidth
	 * @return
	 */
	public ImageInfoRelation getOneByWidth(Integer relationId, Integer type, String fileWidth) {
		Example example = new Example(ImageInfoRelation.class);
		example.createCriteria().andEqualTo("relationId", relationId).andEqualTo("type", type).andEqualTo("fileWidth", fileWidth);
		return mapper.selectOneByExample(example);
	}

	/**
	 * 查询所有影像图片信息
	 * @return
	 */
	public ObjectRestResponse getAll(ImageInfoRelationDto imageInfoRelationDto) {
		Example example = new Example(ImageInfoRelation.class);
		Query query = new Query(imageInfoRelationDto);
		example.orderBy("updTime").desc();
		PageDataVO<ImageInfoRelation> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByExample(example));

		return ObjectRestResponse.succ(pageDataVO);
	}

	/**
	 * 根据Id查询所有相似图片
	 * @param relationIds
	 * @return
	 */
	public List<ImageInfoRelation> getAllByIds(String relationIds) {
		if (StringUtils.isBlank(relationIds)) {
			return new ArrayList<>();
		}
		String[] arr = relationIds.split(",");
		if (arr == null) {
			return new ArrayList<>();
		}
		Example example = new Example(ImageInfoRelation.class);
		example.createCriteria().andIn("id", Arrays.asList(arr));
		return mapper.selectByExample(example);
	}
}