package com.upyuns.platform.rs.website.biz;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.FeedbackInfoDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.FeedbackInfo;
import com.upyuns.platform.rs.website.mapper.FeedbackInfoMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import javax.servlet.http.HttpServletRequest;

/**
 * 反馈信息
 *
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2020-12-22 13:38:56
 */
@Service
public class FeedbackInfoBiz extends BaseBiz<FeedbackInfoMapper, FeedbackInfo> {

	@Autowired
	UserFeign userFeign;
	@Autowired
	HttpServletRequest request;


	public ObjectRestResponse addObj(FeedbackInfo feedbackInfo) {
		if (feedbackInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		AppUserDTO appUserDTO = userFeign.userDetailByToken(request.getHeader("Authorization")).getData();
		if (appUserDTO == null) {
			return ObjectRestResponse.createFailedResult(ResultCode.RSTOKEN_EXPIRED_CODE, ResultCode.getMsg(ResultCode.RSTOKEN_EXPIRED_CODE));
		}
		feedbackInfo.setUserId(appUserDTO.getUserid());
		insertSelectiveRe(feedbackInfo);
		return ObjectRestResponse.succ();
	}


	public ObjectRestResponse getAll(FeedbackInfoDto feedbackInfoDto) {
		Query query = new Query(feedbackInfoDto);
		Example example = new Example(FeedbackInfo.class);
		Example.Criteria criteria = example.createCriteria();
		if (feedbackInfoDto.getType() != null) {
			criteria.andEqualTo("type", feedbackInfoDto.getType());
		}
		if (feedbackInfoDto.getUserId() != null) {
			criteria.andEqualTo("userId", feedbackInfoDto.getUserId());
		}
		if (StringUtils.isNotBlank(feedbackInfoDto.getKeywords())) {
			criteria.andLike("name", "%" + feedbackInfoDto.getKeywords() + "%")
					.orLike("phone", "%" + feedbackInfoDto.getKeywords() + "%");
		}
		PageDataVO<FeedbackInfo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByExample(example));
		return ObjectRestResponse.succ(pageDataVO);
	}

}