package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2020-12-11 10:25:29
 */
@Data
@Table(name = "company_info")
public class CompanyInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  公司介绍
     */
    @Column(name = "intro")
	@ApiModelProperty(value = "公司介绍")
    private String intro;
	
	    /**
     *  电话信息
     */
    @Column(name = "phone")
	@ApiModelProperty(value = "电话信息")
    private String phone;
	
	    /**
     *  电子邮件
     */
    @Column(name = "email")
	@ApiModelProperty(value = "电子邮件")
    private String email;
	
	    /**
     *  地址
     */
    @Column(name = "address")
	@ApiModelProperty(value = "地址")
    private String address;
	
	    /**
     *  图片logo
     */
    @Column(name = "pic")
	@ApiModelProperty(value = "图片logo")
    private String pic;
	
	    /**
     *  纬度
     */
    @Column(name = "lat")
	@ApiModelProperty(value = "纬度")
    private String lat;
	
	    /**
     *  经度
     */
    @Column(name = "lng")
	@ApiModelProperty(value = "经度")
    private String lng;
	
	    /**
     *  公司名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "公司名称")
    private String name;

    private Integer isDel;

    private Integer indexShow;

	/**
	 *  创建时间
	 */
	@Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
	private Date crtTime;

	/**
	 *  更新时间
	 */
	@Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
	private Date updTime;

}
