package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.UserAgentUtil;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.upyuns.platform.rs.datacenter.biz.RscpAreaImageTotalBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImageDataTotalBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImagePriceBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaImageTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import com.upyuns.platform.rs.datacenter.mapper.RscpAreaInfoMapper;
import com.upyuns.platform.rs.datacenter.pojo.ImageDataVO;
import com.upyuns.platform.rs.datacenter.pojo.ImagePageFeginDTO;
import com.upyuns.platform.rs.datacenter.pojo.ImageTotalInputDTO;
import com.upyuns.platform.rs.datacenter.vo.ImageInputVO;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.*;
import sun.nio.cs.ext.Big5;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;
import static com.github.wxiaoqi.security.common.util.process.ResultCode.PARAM_ILLEGAL_CODE;

@RestController
@RequestMapping("/web/imageData")
public class RscpImageDataTotalController extends BaseController<RscpImageDataTotalBiz, RscpImageDataTotal> {

    @Autowired
    RscpAreaImageTotalBiz rscpAreaImageTotalBiz;

    @Autowired
    RscpImagePriceBiz rscpImagePriceBiz;

    @RequestMapping(value = "/app/unauth/query", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse unauthQuery(PageParam pageParam) {
        return ObjectRestResponse.succ(baseBiz.selectByQuery(new Query(pageParam)));
    }

    @RequestMapping(value = "/app/unauth/aaa", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse unauthAaaa(PageParam pageParam) {
        ImageInputVO vo = JSONUtil.toBean("{\"rightTopLon\":87.33106598951404,\"leftBottomLon\":87.26891697286784,\"imageCloudage\":0.18,\"imageSensorType\":\"micro\",\"imageWidthInPixels\":5001,\"imageSpectrumTypeDisplay\":\"{全色,多光谱}\",\"imageSatelliteTypeDisplay\":\"newsat8\",\"supplier\":\"Satellogic\",\"imageSensorId\":\"micro\",\"imageProductTime\":\"2020-09-14 04:42:05\",\"leftTopLat\":44.022589860423246,\"imageResolution\":[1,1],\"rightBottomLon\":87.33106598951404,\"imageStartTime\":\"2020-09-14 04:42:05\",\"imageCenterTime\":\"2020-09-14 04:42:05\",\"imageProjection\":\"WGS-84\",\"imageFilePath\":\"/rscloudmart/data/sateLLogic/20201220/20200914_044205_SN8_L1_Changji-China/20200914_044205_SN8_L1_Changji-China.zip\",\"imageSpectrumType\":\"{QS,DGP}\",\"imageSatelliteType\":\"newsat8\",\"imageSceneId\":\"newsat8_micro_L1_radiance_dca17df4-754d-4f02-ac65-3de4bfc66254_0_11_0\",\"imageCenterPointLon\":87.29999148119094,\"imageTakeTime\":\"2020-09-14 04:42:05\",\"leftTopLon\":87.26891697286784,\"imageEndTime\":\"2020-09-14 04:42:05\",\"rightTopLat\":44.022589860423246,\"leftBottomLat\":43.9774001602467,\"name\":\"20200914_044205_SN8_L1_Changji-China\",\"thumbnailPath\":\"/users/rscloudmart/thumbnail/data/sateLLogic/20201220/20200914_044205_SN8_L1_Changji-China\",\"imageCenterPointLat\":43.99999501033497,\"files\":[\"/20200914_044205_SN8_L1_Metadata.xml\",\"/20200914_044205_SN8_L1_RGB_Changji-China_showcase_Quicklook_800_800.png\",\"/20200914_044205_SN8_L1_RGB_Changji-China_showcase_Quicklook_800_800.jpeg\",\"/20200914_044205_SN8_L1_RGB_Changji-China_showcase_Quicklook_205_205.jpeg\",\"/20200914_044205_SN8_L1_RGB_Changji-China_showcase_Quicklook_98_98.jpeg\"],\"imageProductFormat\":\"TIFF\",\"imageHeightInPixels\":\"5001\",\"rightBottomLat\":43.9774001602467}", ImageInputVO.class);
        baseBiz.aaa(vo);
        return ObjectRestResponse.succ();
    }

//   resolution
//	     分辨率
//	 spectrum
//	     光谱
//	 startDate
//	     2017/04/14
//     endDate
//	     2017/07/13
//     geom
//	     {"type":"Polygon","coordinates":[[[3,4],[3,2],[1,2],[1,4],[3,4]]]}
//	 areaNo
//	     行政区域
//	 areaName
//	     行政区域名称
//	 resolutionSa
//	     分辨率/卫星
//	 saSensor
//	     卫星/传感器 {'GF2':'[PMS]','GF4':'[IRS]','GF1':'[PMS]'}
//	 shp
//	     2
//     cloud
//	     云量 10
//     imageSatelliteType
//	     卫星
//	 request
//	 resId
//	     分辨率id

    @RequestMapping(value = "/app/unauth/queryDataList", method = RequestMethod.POST)
    @IgnoreUserToken
    public ObjectRestResponse queryDataList(@RequestBody QueryDTO dto) {
        if(RscpImageDataTotalController.QueryDTO.TYPE_AREA == dto.getType()) {
            return ObjectRestResponse.succ(rscpAreaImageTotalBiz.queryDataList(dto));
        }else {
            return ObjectRestResponse.succ(baseBiz.queryDataAreaList(dto));
        }
    }

    @RequestMapping(value = "/app/unauth/detailById", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<List<RscpImageDataTotal>> detailById(String id){
//        List<RscpImageDataTotal> list2 = baseBiz.selectByAttrs(RscpImageDataTotal::getId, CollUtil.newArrayList(id));
//        if(list2.size() > 0) {
//            RscpImageDataTotal rscpImageDataTotal = list2.get(0);
//            rscpImageDataTotal.setRange(baseBiz.geoJsonByRange(rscpImageDataTotal.getRange()));
//            return ObjectRestResponse.succ(list2.get(0));
//        }
        return ObjectRestResponse.succ(baseBiz.queryDataList(id));
    }

    @RequestMapping(value = "/app/unauth/Fegin/queryByIds", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<List<ImageDataVO>> queryByIds(String ids){
        List<RscpImagePrice> list = rscpImagePriceBiz.selectByWeekend(w -> {
            w.andEqualTo(RscpImagePrice::getStatus, SYS_TRUE);
            return w;
        }, " daily_sort asc");

        List<RscpImageDataTotal> list2 = baseBiz.selectByAttrs(RscpImageDataTotal::getId, CollUtil.toList(ids.split(",")));
        List<ImageDataVO> list3 = CollUtil.newArrayList();
        list2.forEach(t -> {
            ImageDataVO vo = BeanUtil.toBean(t, ImageDataVO.class);
            vo.setBeginTime(t.getImageTakeTime());
            list.forEach(p -> {
                if(t.getImageSatelliteType().equals(p.getImageSatelliteType())
                && t.getImageSensorType().equals(p.getImageSensorType())) {
                    vo.setPrice(p.getPrice());
                }
            });
            list3.add(vo);
        });
        return ObjectRestResponse.succ(list3);
    }

    @RequestMapping(value = "/app/unauth/Fegin/pageBykey", method = RequestMethod.POST)
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<ImageDataVO>> pageBykey(@RequestBody ImagePageFeginDTO dto){
        return ObjectRestResponse.succ(
                PageDataVO.pageInfo(dto.initQuery(),()-> baseBiz.selectByWeekend(w -> {
                    if(StrUtil.isNotBlank(dto.getKeyword())) {
                        w.andLike(RscpImageDataTotal::getName, "%"+ dto.getKeyword()+ "%");
                    }
                    w.andEqualTo(RscpImageDataTotal::getIsDel, SYS_FALSE);
                    return w;
                }), ImageDataVO.class)
        );
    }


    @Data
    static public class QueryDTO {
        public static final int TYPE_AREA = 1;
        public static final int TYPE_GEOM = 2;
        Integer type;
	    String startDate;
        String endDate;
        BigDecimal resolution;
        String startDateTime;
        String endDateTime;
        String geom;
        String areaNo;
        String provinceNo;
        List<satelliteDTO> saSensor;
        BigDecimal cloud;

        public void setStartDate(String startDate) {
            this.startDate = startDate;
            this.startDateTime = DateUtil.beginOfDay(DateUtil.parseDate(startDate)).toString();
        }

        public void setEndDate(String endDate) {
            this.endDate = endDate;
            this.endDateTime = DateUtil.endOfDay(DateUtil.parseDate(endDate)).toString();
        }

        public void setAreaNo(String areaNo) {
            this.areaNo = areaNo;
            if(StrUtil.isNotBlank(areaNo)) {
                if(!areaNo.substring(2, 6).equals("0000")){
                    provinceNo = areaNo.substring(0, 2);
                }
            }
        }
    }

    @Data
    static public class satelliteDTO {
        String satellite;
        List<String> sensors = CollUtil.newArrayList();
    }
}