package com.upyuns.platform.rs.datacenter.mapper;

import com.upyuns.platform.rs.datacenter.entity.RscpAreaInfo;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.rest.RscpImageDataTotalController;
import org.apache.ibatis.annotations.Select;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestParam;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

public interface RscpImageDataTotalMapper extends Mapper<RscpImageDataTotal> {

    public List<RscpImageDataTotal> queryDataList(RscpImageDataTotalController.QueryDTO dto);

    public List<RscpImageDataTotal> queryDataById(@Param("id")String id );


//    //左上角经度
//    private BigDecimal leftTopLon;
//    //左上角维度
//    private BigDecimal leftTopLat;
//
//    //左下角经度
//    private BigDecimal leftBottomLon;
//    //左下角维度
//    private BigDecimal leftBottomLat;
//
//    //右下角经度
//    private BigDecimal rightBottomLon;
//    //右下角维度
//    private BigDecimal rightBottomLat;
//
//    //右上角经度
//    private BigDecimal rightTopLon;
//    //右上角维度
//    private BigDecimal rightTopLat;
    @Select("select st_asgeojson(#{rangeMeta},16,0)")
    String geoJsonByRange(@Param("rangeMeta")String rangeMeta);

    @Select("SELECT st_GeomFromText('MULTIPOLYGON(((${leftTopLon} ${leftTopLat}  ,${leftBottomLon} ${leftBottomLat}  , ${rightBottomLon} ${rightBottomLat}  ,${rightTopLon} ${rightTopLat},   ${leftTopLon} ${leftTopLat})))',4326)")
    String getBinNameByGId(BigDecimal leftTopLon, BigDecimal leftTopLat, BigDecimal leftBottomLon, BigDecimal leftBottomLat, BigDecimal rightBottomLon, BigDecimal rightBottomLat, BigDecimal rightTopLon, BigDecimal rightTopLat);

}