package com.github.wxiaoqi.security.admin.vo;

import com.github.wxiaoqi.security.admin.entity.Group;
import com.github.wxiaoqi.security.admin.entity.User;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.stream.Collectors;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BaseUserVO extends User {

    private List<Group> groupList;
    private String groupStr;

    public  String getGroupStr(){
        if (groupList != null && groupList.size() > 0){
            groupStr= groupList.stream().map(Group::getName).collect(Collectors.joining(","));
        }
        return  groupStr;
    }

}