package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.OrderInfoBiz;
import com.upyuns.platform.rs.website.dto.ConfirmOrderDto;
import com.upyuns.platform.rs.website.dto.OrderInfoDto;
import com.upyuns.platform.rs.website.entity.OrderInfo;
import com.upyuns.platform.rs.website.service.ConfirmOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("orderInfo/web")
public class OrderInfoWebController extends BaseController<OrderInfoBiz,OrderInfo> {

	@Autowired
	ConfirmOrderService confirmOrderService;

	@PostMapping(value = "confirmOrder")
	public ObjectRestResponse confirmOrder(@RequestBody ConfirmOrderDto confirmOrderDto) {
		return confirmOrderService.confirmOrderInfo(confirmOrderDto);
	}

	@PostMapping(value = "submitOrder")
	public ObjectRestResponse submitOrder(@RequestBody OrderInfoDto orderInfoDto) {
		return baseBiz.submitOrder(orderInfoDto);
	}
}