package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.OrderUtil;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.upyuns.platform.rs.universal.constant.DictionaryKey;
import com.upyuns.platform.rs.universal.entity.Dictionary;
import com.upyuns.platform.rs.universal.feign.ThirdFeign;
import com.upyuns.platform.rs.website.dto.ItemInfoDto;
import com.upyuns.platform.rs.website.dto.OrderInfoDto;
import com.upyuns.platform.rs.website.dto.UserOrderDto;
import com.upyuns.platform.rs.website.entity.*;
import com.upyuns.platform.rs.website.mapper.OrderItemMapper;
import com.upyuns.platform.rs.website.type.OrderTypeEnum;
import com.upyuns.platform.rs.website.vo.ItemInfoVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.mapper.OrderInfoMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 订单信息
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Service
public class OrderInfoBiz extends BaseBiz<OrderInfoMapper, OrderInfo> {

	@Autowired
	OrderItemBiz orderItemBiz;
	@Autowired
	IndustryApplicationInfoBiz industryApplicationInfoBiz;

	@Autowired
	ImageImgStorageBiz imageImgStorageBiz;

	@Autowired
	ShoppingCartInfoBiz shoppingCartInfoBiz;

	@Autowired
	ImageInfoRelationBiz imageInfoRelationBiz;

	@Autowired
	ThirdFeign thirdFeign;

	@Autowired
	UserFeign userFeign;

	@Autowired
	HttpServletRequest request;

	@Autowired
	UserAddressBiz userAddressBiz;

	@Autowired
	OrderEInvoiceBiz orderEInvoiceBiz;

	@Autowired
	UserInvoiceBiz userInvoiceBiz;

	/**
	 * 添加订单
	 * @param orderInfo
	 * @return
	 */
	public ObjectRestResponse addUpdate(OrderInfo orderInfo) {
		if (orderInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (orderInfo.getOrderId() == null) {
			insertSelectiveRe(orderInfo);
		} else {
			OrderInfo old = selectById(orderInfo.getOrderId());
			BeanUtil.copyProperties(orderInfo, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 下单
	 * @param orderInfo
	 * @return
	 */
	public ObjectRestResponse generateOrder(OrderInfo orderInfo) {
		if (orderInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (StringUtils.isNotBlank(orderInfo.getOrderNo())) {
			orderInfo.setOrderNo(OrderUtil.GetOrderNumber("", OrderUtil.APP_MID));
		}
		OrderInfo old = getOneByOrderNo(orderInfo.getOrderNo());
		while (old != null) {
			orderInfo.setOrderNo(OrderUtil.GetOrderNumber("", OrderUtil.APP_MID));
			old = getOneByOrderNo(orderInfo.getOrderNo());
		}
		return addUpdate(orderInfo);
	}

	/**
	 * 根据订单号查询订单信息
	 * @param orderNo
	 * @return
	 */
	public OrderInfo getOneByOrderNo(String orderNo) {
		Example example = new Example(OrderInfo.class);
		example.createCriteria().andEqualTo("orderNo", orderNo).andNotEqualTo("status", -1).andNotEqualTo("status", -2);
		return mapper.selectOneByExample(example);
	}

	/**
	 * 查询用户所有订单
	 * @param userOrderDto
	 * @return
	 */
	public List<OrderInfo> getUserOrder(UserOrderDto userOrderDto) {
		Example example = new Example(OrderInfo.class);
		Example orderItemExample = new Example(OrderItem.class);
		Example.Criteria orderInfoCriteria = example.createCriteria();
		Example.Criteria orderItemCriteria = orderItemExample.createCriteria();
		if (userOrderDto.getStatus() != null) {
			orderInfoCriteria.andEqualTo("status", userOrderDto.getStatus());
		}
		if (userOrderDto.getPayStatus() != null) {
			orderInfoCriteria.andEqualTo("payStatus", userOrderDto.getPayStatus());
		}
		if (userOrderDto.getUserId() != null) {
			orderInfoCriteria.andEqualTo("userId", userOrderDto.getUserId());
		}
		if (StringUtils.isNotBlank(userOrderDto.getName())) {
			orderItemCriteria.andLike("name", "%"+ userOrderDto.getName() +"%");
		}
		orderInfoCriteria.andNotEqualTo("status", -1);
		example.orderBy("updTime").desc();
		List<OrderInfo> orderInfoList = mapper.selectByExample(example);
		if (orderInfoList != null) {

		}
		return new ArrayList<>();
	}


	/**
	 * 提交订单
	 * @param orderInfoDto
	 * @return
	 */
	public ObjectRestResponse submitOrder(OrderInfoDto orderInfoDto) {
		AppUserDTO appUserDTO = userFeign.userDetailByToken(request.getHeader("Authorization")).getData();
		if (appUserDTO == null) {
			return ObjectRestResponse.createFailedResult(ResultCode.RSTOKEN_EXPIRED_CODE, ResultCode.getMsg(ResultCode.RSTOKEN_EXPIRED_CODE));
		}

		if (orderInfoDto == null || orderInfoDto.getItemInfoDtoList() == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		List<ItemInfoDto> itemInfoDtoList = orderInfoDto.getItemInfoDtoList();
		List<OrderItem> orderItemList = new ArrayList<>();
		AtomicReference<Integer> number = new AtomicReference<>(0);
		AtomicReference<Double> amount = new AtomicReference<>((double) 0);
		itemInfoDtoList.parallelStream().forEach(itemInfoDto -> {
			switch (OrderTypeEnum.getByCode(itemInfoDto.getType())) {
				//标准数据
				case STANDARD_DATA:

					break;
				//行业应用
				case INDUSTRY_INFO:
					IndustryApplicationInfo industryApplicationInfo = industryApplicationInfoBiz.getOneById(itemInfoDto.getId()).getData();
					if (industryApplicationInfo != null) {
						OrderItem orderItem = new OrderItem();
						orderItem.setType(itemInfoDto.getType());
						orderItem.setTotalAmount(industryApplicationInfo.getPrice().multiply(new BigDecimal(itemInfoDto.getNumber())));
						orderItem.setPrice(industryApplicationInfo.getPrice());
						orderItem.setNumber(itemInfoDto.getNumber());
						orderItem.setName(industryApplicationInfo.getTitle());
						orderItem.setItemPic(industryApplicationInfo.getCoverImg());
						orderItem.setDetailJson(JSONObject.toJSONString(industryApplicationInfo));
						orderItem.setDetailId(industryApplicationInfo.getId());
						orderItemList.add(orderItem);
						//总数量
						number.updateAndGet(v -> v + itemInfoDto.getNumber());
						BigDecimal totalAmount = industryApplicationInfo.getPrice().multiply(new BigDecimal(itemInfoDto.getNumber()));
						amount.updateAndGet(v -> new Double((double) (v + totalAmount.doubleValue())));
					}
					break;
				//影像图库
				case IMAGE_STORAGE:
					ImageInfoRelation imageInfoRelation = imageInfoRelationBiz.selectById(itemInfoDto.getId());
					if (imageInfoRelation != null ) {
						ImageImgStorage imageImgStorage = imageImgStorageBiz.getDetail(itemInfoDto.getId()).getData();
						if (imageImgStorage != null) {
							List<ImageInfoRelation> imageInfoRelationList = new ArrayList<>();
							imageInfoRelationList.add(imageInfoRelation);
							imageImgStorage.setImageInfoRelationList(imageInfoRelationList);
							OrderItem orderItem = new OrderItem();
							orderItem.setType(itemInfoDto.getType());
							orderItem.setTotalAmount(imageInfoRelation.getPrice().multiply(new BigDecimal(itemInfoDto.getNumber())));
							orderItem.setPrice(imageInfoRelation.getPrice());
							orderItem.setNumber(itemInfoDto.getNumber());
							orderItem.setName(imageImgStorage.getName());
							orderItem.setItemPic(imageImgStorage.getCoverImg());
							orderItem.setDetailJson(JSONObject.toJSONString(imageImgStorage));
							orderItem.setDetailId(imageImgStorage.getId());
							orderItemList.add(orderItem);
							//总数量
							number.updateAndGet(v -> v + itemInfoDto.getNumber());
							BigDecimal totalAmount = imageInfoRelation.getPrice().multiply(new BigDecimal(itemInfoDto.getNumber()));
							amount.updateAndGet(v -> new Double((double) (v + totalAmount.doubleValue())));
						}
					}
					break;
				//购物车
				case SHOPPING_CART_INFO:
					ShoppingCartInfo shoppingCartInfo = shoppingCartInfoBiz.selectById(itemInfoDto.getId());
					if (shoppingCartInfo != null) {
						OrderItem orderItem = new OrderItem();
						orderItem.setType(itemInfoDto.getType());
						orderItem.setTotalAmount(shoppingCartInfo.getPrice().multiply(new BigDecimal(itemInfoDto.getNumber())));
						orderItem.setPrice(shoppingCartInfo.getPrice());
						orderItem.setNumber(itemInfoDto.getNumber());
						orderItem.setName(shoppingCartInfo.getName());
						orderItem.setItemPic(shoppingCartInfo.getItemPic());
						orderItem.setDetailJson(shoppingCartInfo.getDetailJson());
						orderItem.setDetailId(shoppingCartInfo.getDetailId());
						orderItemList.add(orderItem);
						number.updateAndGet(v -> v + itemInfoDto.getNumber());
						BigDecimal totalAmount = shoppingCartInfo.getTotalAmount();
						amount.updateAndGet(v -> new Double((double) (v + totalAmount.doubleValue())));
					}
					break;
				default:
					break;
			}
		});

		OrderInfo orderInfo = new OrderInfo();
		orderInfo.setRealName(appUserDTO.getRealname());
		orderInfo.setUserId(appUserDTO.getUserid());
		orderInfo.setPhone(appUserDTO.getUsername());
		orderInfo.setNickname(appUserDTO.getNickname());
		orderInfo.setHeadImg(appUserDTO.getHeadimgurl());
		if (orderInfoDto.getUserAddressId() != null) {
			UserAddress userAddress = userAddressBiz.selectById(orderInfoDto.getUserAddressId());
			if (userAddress != null) {
				orderInfo.setReceiveName(userAddress.getConsigneeName());
				orderInfo.setReceivePhone(userAddress.getConsigneePhone());
				orderInfo.setReceiveAddress(userAddress.getProvince() + userAddress.getCity() + userAddress.getTown() + userAddress.getConsigneeAddress());
			}
		}
		orderInfo.setRemark(orderInfoDto.getRemark());
		orderInfo.setAmount(new BigDecimal(amount.get()));
		Dictionary dictionary = thirdFeign.findDictionaryByTypeAndCode(DictionaryKey.APP_ORDER, DictionaryKey.SEND_FEE);
		if (dictionary != null && StringUtils.isNotBlank(dictionary.getDetail())) {
			orderInfo.setFee(new BigDecimal(dictionary.getDetail()));
		}
		if (orderInfo.getFee() != null) {
			orderInfo.setTotalAmount(orderInfo.getAmount().add(orderInfo.getFee()));
		}
		orderInfo.setSendType(orderInfoDto.getSendType());
		orderInfo.setType(1);
		/**
		 * 新增订单
		 */
		orderInfo.setOrderNo(OrderUtil.GetOrderNumber("", OrderUtil.APP_MID));
		generateOrder(orderInfo);
		orderItemList.parallelStream().forEach(orderItem -> {
			if (orderItem != null) {
				orderItem.setOrderId(orderInfo.getOrderId());
				orderItemBiz.insertSelective(orderItem);
			}
		});

		//订单发票信息
		if (orderInfoDto.getUserInvoiceId() != null) {
			UserInvoice userInvoice = userInvoiceBiz.selectById(orderInfoDto.getUserInvoiceId());
			if (userInvoice != null) {
				OrderEInvoice orderEInvoice = new OrderEInvoice();
				orderEInvoice.setAmount(orderInfo.getAmount());
				orderEInvoice.setType(1);
				orderEInvoice.setOrderIds(orderInfo.getOrderId() + "");
				orderEInvoice.setTitleType(userInvoice.getTitleType());
				orderEInvoice.setTitleName(userInvoice.getTitleName());
				orderEInvoice.setTaxCode(userInvoice.getTaxCode());
				orderEInvoice.setContentRemark(orderInfoDto.getRemark());
				orderEInvoice.setContentAccount(userInvoice.getOpenBank() + "  " + userInvoice.getAccount());
				orderEInvoice.setContentContact(orderInfo.getReceiveAddress() + "  " + orderInfo.getReceiveName() + "  " + orderInfo.getReceivePhone());
				//发票内容
				orderEInvoice.setContentTitle("");
				orderEInvoiceBiz.addUpdate(orderEInvoice);
			}
		}

		return ObjectRestResponse.succ();
	}

}