package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.CommonInfoDto;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.CommonInfo;
import com.upyuns.platform.rs.website.mapper.CommonInfoMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 通用信息
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-11-24 14:37:58
 */
@Service
public class CommonInfoBiz extends BaseBiz<CommonInfoMapper,CommonInfo> {

	/**
	 * 新增通用信息
	 * @param commonInfo
	 * @return
	 */
	public ObjectRestResponse addUpdate(CommonInfo commonInfo) {
		if (commonInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (commonInfo.getId() != null) {
			CommonInfo old = selectById(commonInfo.getId());
			if (old == null || old.getIsDel() == 1) {
				return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
			}
			BeanUtil.copyProperties(commonInfo, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		} else {
			insertSelectiveRe(commonInfo);
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 根据类型查询信息
	 * @param type
	 * @return
	 */
	public List<CommonInfo> getByType(Integer type) {
		Example example = new Example(CommonInfo.class);
		example.createCriteria().andEqualTo("type", type).andEqualTo("isDel", 0);
		example.orderBy("rank");
		return mapper.selectByExample(example);
	}


	public ObjectRestResponse getAll(CommonInfoDto commonInfoDto) {
		Example example = new Example(CommonInfo.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isDel", 0);
		if (commonInfoDto.getType() != null) {
			criteria.andEqualTo("type", commonInfoDto.getType());
		}
		Query query = new Query(commonInfoDto);
		PageDataVO<CommonInfo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByExample(example));
		return ObjectRestResponse.succ(pageDataVO);
	}
}