package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 定制表单
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2020-12-10 19:03:54
 */
@Data
@Table(name = "custom_form")
public class CustomForm implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  定制类型 1--标准数据；2--行业应用；3--图库
     */
    @Column(name = "type")
	@ApiModelProperty(value = "定制类型 1--标准数据；2--行业应用；3--图库")
    private Integer type;
	
	    /**
     *  省编码
     */
    @Column(name = "province_code")
	@ApiModelProperty(value = "省编码")
    private String provinceCode;
	
	    /**
     *  市编码
     */
    @Column(name = "city_code")
	@ApiModelProperty(value = "市编码")
    private String cityCode;
	
	    /**
     *  区编码
     */
    @Column(name = "area_code")
	@ApiModelProperty(value = "区编码")
    private String areaCode;
	
	    /**
     *  地区详情
     */
    @Column(name = "area_detail")
	@ApiModelProperty(value = "地区详情")
    private String areaDetail;
	
	    /**
     *  分辨率
     */
    @Column(name = "resolution")
	@ApiModelProperty(value = "分辨率")
    private String resolution;
	
	    /**
     *  开始时间
     */
    @Column(name = "start_time")
	@ApiModelProperty(value = "开始时间")
    private Long startTime;
	
	    /**
     *  结束时间
     */
    @Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
    private Long endTime;
	
	    /**
     *  获取类型 101--数据API；102--实体数据 201--报告；202--web平台；203--其他 
     */
    @Column(name = "gain_type")
	@ApiModelProperty(value = "获取类型 101--数据API；102--实体数据 201--报告；202--web平台；203--其他 ")
    private Long gainType;
	
	    /**
     *  需求描述、说明
     */
    @Column(name = "descr")
	@ApiModelProperty(value = "需求描述、说明")
    private String descr;
	
	    /**
     *  联系人
     */
    @Column(name = "contact_user")
	@ApiModelProperty(value = "联系人")
    private String contactUser;
	
	    /**
     *  联系方式
     */
    @Column(name = "contact_phone")
	@ApiModelProperty(value = "联系方式")
    private String contactPhone;
	
	    /**
     *  行业应用一级id
     */
    @Column(name = "industry_type_first_id")
	@ApiModelProperty(value = "行业应用一级id")
    private Integer industryTypeFirstId;
	
	    /**
     *  行业应用二级id
     */
    @Column(name = "industry_type_second_id")
	@ApiModelProperty(value = "行业应用二级id")
    private Integer industryTypeSecondId;
	
	    /**
     *  备注
     */
    @Column(name = "backup")
	@ApiModelProperty(value = "备注")
    private String backup;
	
	    /**
     *  数据类型
     */
    @Column(name = "data_type")
	@ApiModelProperty(value = "数据类型")
    private Integer dataType;
	
	    /**
     *  数据格式
     */
    @Column(name = "data_format")
	@ApiModelProperty(value = "数据格式")
    private Integer dataFormat;
	
	    /**
     *  订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
    private Integer orderId;
	
	    /**
     *  押金订单id
     */
    @Column(name = "deposit_order_id")
	@ApiModelProperty(value = "押金订单id")
    private Integer depositOrderId;
	
	    /**
     *  是否删除：0、否， 1、是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0、否， 1、是")
    private Integer isDel;

	/**
	 *  省名称
	 */
	@Column(name = "province_name")
	@ApiModelProperty(value = "省名称")
	private String provinceName;

	/**
	 *  市名称
	 */
	@Column(name = "city_name")
	@ApiModelProperty(value = "市名称")
	private String cityName;

	/**
	 *  区名称
	 */
	@Column(name = "area_name")
	@ApiModelProperty(value = "区名称")
	private String areaName;

}
