package com.upyuns.platform.rs.website.dto;

import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName : OrderInfoDto
 * @Description : 添加订单信息
 * @Author : jiaoruizhen
 * @Date: 2020-12-12 17:09
 */
@Data
public class OrderInfoDto extends PageParam {
	/**
	 *  订单备注
	 */
	@ApiModelProperty(value = "订单备注")
	private String remark;

	/**
	 *  配送方式:1、线上配送，2、快递配送
	 */
	@ApiModelProperty(value = "配送方式:1、线上配送，2、快递配送")
	private Integer sendType;

	/**
	 * 地址ID
	 */
	private Integer userAddressId;

	/**
	 * 发票ID
	 */
	private Integer userInvoiceId;

	/**
	 * 商品信息ID
	 */
	private List<ItemInfoDto> itemInfoDtoList;


	//详情ID
	Integer detailId;

	//1、标准数据，2、影像图库，3、行业应用信息
	Integer type;

	//数量
	Integer number;

	//单价
	BigDecimal price;

	//文件地址
	String filePath;

}
