package com.upyuns.platform.rs.universal.interceptor;



import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.util.UserAgentUtil;
import com.upyuns.platform.rs.universal.biz.WeixinService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;


/**
 * 微信登陆拦截器
 * 
 * @author
 *
 */
@Slf4j
public class WeChatH5LoginInterceptor extends HandlerInterceptorAdapter {






	@Value("${wx.sendUrl}")
	private String  sendUrl;

	@Autowired
	WeixinService weixinService;


	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

		String curr_domain = request.getServerName();
		log.info("curr_domain:" + curr_domain);
		log.info("address:" + request.getRequestURL().toString());
		log.info("params:" + request.getQueryString());

		boolean isWx = UserAgentUtil.isWexinBrowser(request);
		if (isWx) {
			//session里面获取用户信息
			String openId=weixinService.getSession(request);
			if (StringUtils.isNotBlank(openId)){
                return  true;
			}
			Map<String,Object> result=new HashMap<>();
			result.put("status",1001);
			JSONObject json = new JSONObject();
			json.put("sendUrl",sendUrl);
			result.put("data",json);
			response.getWriter().write(result.toString());
			return false;
		}
		return  true;
	}



}
