package com.upyuns.platform.rs.universal.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;

import com.upyuns.platform.rs.universal.service.TrafficViolationsService;
import com.upyuns.platform.rs.universal.vo.RentViolationDTO;
import com.upyuns.platform.rs.universal.vo.TrafficViolations;
import com.upyuns.platform.rs.universal.vo.ViolationVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("3p/tv")
@Slf4j
public class TrafficViolationsController {
    @Autowired
    TrafficViolationsService tvService;

    /**
     * 获取支持的城市
     * @return
     */
    @GetMapping("/city")
    public ObjectRestResponse getCityInfo() {
        try {
            return  ObjectRestResponse.succ(JSONObject.parse(tvService.getCity()));
        } catch (Exception e) {
            log.error(e.getMessage(), e);;
            return ObjectRestResponse.createDefaultFail();
        }
    }

    /**
     * 违章车辆查询
     * @return
     */
    @PostMapping("/trafficViolations")
    public ObjectRestResponse queryTrafficViolations(@RequestBody TrafficViolations trafficViolations) {
        try {
            return ObjectRestResponse.succ(JSONObject.parse(tvService.queryViolations(trafficViolations)));
        } catch (Exception e) {
            log.error(e.getMessage(), e);;
            return ObjectRestResponse.createDefaultFail();
        }
    }

    /**
     * 车辆类型查询
     * @return
     */
    @GetMapping("/LicensePlateType")
    public ObjectRestResponse getLicensePlateType() {
        try {
            return ObjectRestResponse.succ(tvService.getLicensePlateType());
        } catch (Exception e) {
            log.error(e.getMessage(), e);;
            return ObjectRestResponse.createDefaultFail();
        }
    }

}
