package com.upyuns.platform.rs.datacenter.utils.gdal;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class ImageOperateTools {

    /**
     * tif 文件转 为图片
     * @param inputPath
     * @param outputPath
     * @return
     */
    public static Boolean tif2Pic(String inputPath, String outputPath) {
        //注册GDAL
        gdal.AllRegister();
        //设置中文
        gdal.SetConfigOption("gdal_FILENAME_IS_UTF8", "YES");

        //只读方式读取数据
        Dataset sourceData = gdal.Open(inputPath, gdalconstConstants.GA_ReadOnly);
        if (sourceData == null) {
            return false;
        }
        Driver hDriver = sourceData.GetDriver();
        hDriver.CreateCopy(outputPath, sourceData);

        hDriver.delete();
        sourceData.delete();

        return true;
    }

    //jpeg图片压缩处理
    public static Boolean zipImageFile(String oldFile, String newFile, int width, int height, float quality) {
        if (oldFile == null) {
            return null;
        }
        try {
            /**对服务器上的临时文件进行处理 */
            Image srcFile = ImageIO.read(new File(oldFile));
            /** 宽,高设定 */
            BufferedImage tag = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            tag.getGraphics().drawImage(srcFile, 0, 0, width, height, null);

            /** 压缩之后临时存放位置 */
            FileOutputStream out = new FileOutputStream(newFile);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
            JPEGEncodeParam jep = JPEGCodec.getDefaultJPEGEncodeParam(tag);
            /** 压缩质量 */
            jep.setQuality(quality, true);
            encoder.encode(tag, jep);
            out.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}
