package com.upyuns.platform.rs.datacenter.utils;

import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import org.apache.commons.lang3.StringUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TarFileOperateUtil {

    /**
     * 解压zip压缩包中，指定文件类型的文件
     * @param file
     * @param saveRootDirectory
     * @param suffix
     * @return 返回解压后的文件路径列表
     * @throws Exception
     */
    public static List<String> zipFileRead(String file, String saveRootDirectory, String suffix)throws BaseException {
        try {
            List<String> filePathList = new ArrayList<>();
            String lowerCaseSuffix = suffix;
            if (StringUtils.isBlank(lowerCaseSuffix)) {
                lowerCaseSuffix = lowerCaseSuffix.toLowerCase();
            }
            ZipFile zipFile = new ZipFile(file);
            @SuppressWarnings("unchecked")
            Enumeration<ZipEntry> enu = (Enumeration<ZipEntry>) zipFile.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipElement = enu.nextElement();
                InputStream read = zipFile.getInputStream(zipElement);
                String fileName = zipElement.getName();
                if (!zipElement.isDirectory() && fileName != null) {//是否为文件
                    if (StringUtils.isBlank(lowerCaseSuffix)) {
                        if (zipExecute(zipElement, read, saveRootDirectory)) {
                            filePathList.add(saveRootDirectory + "/" + fileName);
                        }
                    } else if (fileName.toLowerCase().endsWith(lowerCaseSuffix)) {//指定文件类型
                        if (zipExecute(zipElement, read, saveRootDirectory)) {
                            filePathList.add(saveRootDirectory + "/" + fileName);
                        }
                    }
                }
            }
            return filePathList;
        }catch (Exception e) {
            throw new BaseException("xml解析失败", ResultCode.FAILED_CODE);
        }
    }

    private static boolean zipExecute(ZipEntry ze, InputStream read, String saveRootDirectory) throws IOException {
        String fileName = ze.getName();
        File file = new File(saveRootDirectory + "/" + fileName);
        if (!file.exists()) {
            File rootDirectoryFile = new File(file.getParent());
            //创建目录
            if (!rootDirectoryFile.exists()) {
                boolean ifSuccess = rootDirectoryFile.mkdirs();
                if (ifSuccess) {
                    System.out.println("文件夹创建成功!");
                } else {
                    return false;
                }
            }
            //创建文件
            try {
                file.createNewFile();
            } catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        //写入文件
        BufferedOutputStream write = new BufferedOutputStream(new FileOutputStream(file));
        int cha = 0;
        while ((cha = read.read()) != -1) {
            write.write(cha);
        }
        //要注意IO流关闭的先后顺序
        write.flush();
        write.close();
        read.close();
        return true;
    }
}
