package com.upyuns.platform.rs.datacenter.utils;

import com.github.wxiaoqi.security.common.constant.RestCode;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.upyuns.platform.rs.datacenter.vo.ImageStorageVo;
import com.upyuns.platform.rs.gtdata.GtDataRestClient;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class ImageStorageParseUtil {

    @Value("${localDirTemp.tarFileTemp}")
    private static String tarFileTempDir;

    @Autowired
    private static GtDataRestClient gtDataRestClient;

    public static ImageStorageVo tarFileParseGtData(String inputGtPath, String ouputGtDir)throws BaseException {
        //将GT上压缩包下载到本地
        Integer indexOf = inputGtPath.lastIndexOf("/");
        String fileName = inputGtPath.substring(indexOf);
        String dirName = fileName;
        indexOf = inputGtPath.lastIndexOf(".");
        if (indexOf > 0) {
            dirName = dirName.substring(0, indexOf);
        }
        File localDir = new File(tarFileTempDir + "/" + dirName);
        localDir.mkdirs();
        String localInputPath = localDir + "/" + fileName;
        Map<String,Object > result = gtDataRestClient.open(inputGtPath);

        if ((Integer)result.get("HttpStatusCode") != 200) {
            throw new BaseException("文件下载失败", ResultCode.FAILED_CODE);
        }
        try {
            OutputStream outputStream = new FileOutputStream(new File(localInputPath));
            outputStream.write((byte[])result.get("file"));
            outputStream.flush();
            outputStream.close();
        }catch (Exception e) {
            throw new BaseException("文件保存失败", ResultCode.FAILED_CODE);
        }
        return tarFileParse(localInputPath, localDir.getPath(), ouputGtDir);
    }


    public static ImageStorageVo tarFileParse(String inputLocalPath, String localOutputDir, String outputGtPath) throws BaseException {
        if (inputLocalPath.endsWith("zip")) {
            //Satellogic 压缩包解析
            return satellogicParse(inputLocalPath, localOutputDir, outputGtPath);
        }else if (inputLocalPath.endsWith("tar.gz")) {
            throw new BaseException("tar.gz 压缩包未实现", ResultCode.FAILED_CODE);
        }else {
            throw new BaseException("压缩包格式不支持", ResultCode.FAILED_CODE);
        }
    }


    //Satellogic 压缩包解析
    public static ImageStorageVo satellogicParse(String inputLocalPath, String localOutputDir, String outputGtPath) throws BaseException {
        //1、提取解析xml文件
        List<String> xmlPathList = TarFileOperateUtil.zipFileRead(inputLocalPath, localOutputDir,".xml");
        if (xmlPathList == null || xmlPathList.size() == 0) {
            throw  new BaseException("xml文件提取失败", ResultCode.FAILED_CODE);
        }
        ImageStorageVo imageStorageVo = new ImageStorageVo();
        //初始基础或固定信息
        imageStorageVo.setName(FileOperateUtil.getFileNameNotFormat(inputLocalPath));
        imageStorageVo.setImageProductFormat("TIFF");
        imageStorageVo.setImageSpectrumType("{QS,DGP}");
        imageStorageVo.setImageSpectrumTypeDisplay("{全色,多光谱}");
        imageStorageVo.setImageProjection("WGS-84");

        Map<String, String> paramsMap = new HashedMap();
        boolean xmlFlag = false;
        for (String xmlPath : xmlPathList) {
            paramsMap.clear();
            XmlFileOperateUtil.xmlParse(xmlPath, paramsMap);
            if (paramsMap.get("camera") != null && paramsMap.get("bounds") != null) {
                //拍摄时间
                imageStorageVo.setImageTakeTime(paramsMap.get("created_at"));
                imageStorageVo.setImageProductTime(paramsMap.get("created_at"));
                imageStorageVo.setImageEndTime(paramsMap.get("created_at"));
                imageStorageVo.setImageStartTime(paramsMap.get("created_at"));
                imageStorageVo.setImageCenterTime(paramsMap.get("created_at"));
                //供应商
                imageStorageVo.setSupplier(paramsMap.get("supplier"));
                //卫星名称、类型
                imageStorageVo.setImageSatelliteType(paramsMap.get("satellite_name"));
                imageStorageVo.setImageSatelliteTypeDisplay(paramsMap.get("satellite_name"));
                //云量
                imageStorageVo.setImageCloudage(new BigDecimal(paramsMap.get("cloud_pctg")).intValue());
                //传感器类型
                imageStorageVo.setImageSensorType(paramsMap.get("camera"));
                imageStorageVo.setImageSensorId(paramsMap.get("camera"));


                xmlFlag = true;
                break;
            }
        }
        if (!xmlFlag) {
            throw new BaseException("xml 解析失败", ResultCode.FAILED_CODE);
        }
        //2、提取tiff，生成缩略图

        //3、转坐标系
        return imageStorageVo;
    }
}
