package com.upyuns.platform.rs.datacenter.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpAreaImageTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.mapper.RscpImageDataTotalMapper;
import com.upyuns.platform.rs.datacenter.rest.RscpImageDataTotalController;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RscpImageDataTotalBiz extends BaseBiz<RscpImageDataTotalMapper, RscpImageDataTotal> {

    public List<RscpImageDataTotal> queryDataList(RscpImageDataTotalController.QueryDTO dto) {
        return mapper.queryDataList(dto);
    }

    public List<RscpAreaImageTotal> queryDataAreaList(RscpImageDataTotalController.QueryDTO dto) {
        List<RscpImageDataTotal> list = mapper.queryDataList(dto);
        List<RscpAreaImageTotal> list2 = CollUtil.newArrayList();
        if(CollUtil.isNotEmpty(list)) {
            for(RscpImageDataTotal ridt : list) {
                RscpAreaImageTotal rait = BeanUtil.toBean(ridt, RscpAreaImageTotal.class);
                rait.setBeginTime(ridt.getImageTakeTime());
                list2.add(rait);
            }
        }
        return list2;
    }


}
